/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.FieldError;

public class RepositoryConstraintViolationExceptionMessage {
    private final List<ValidationError> errors = new ArrayList<ValidationError>();

    public RepositoryConstraintViolationExceptionMessage(RepositoryConstraintViolationException exception, MessageSourceAccessor accessor) {
        Assert.notNull((Object)exception, "RepositoryConstraintViolationException must not be null");
        Assert.notNull((Object)accessor, "MessageSourceAccessor must not be null");
        for (FieldError fieldError : exception.getErrors().getFieldErrors()) {
            this.errors.add(ValidationError.of(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), accessor.getMessage(fieldError)));
        }
    }

    @JsonProperty(value="errors")
    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public static final class ValidationError {
        private final String entity;
        private final String property;
        @Nullable
        private final Object invalidValue;
        private final String message;

        private ValidationError(String entity, String property, Object invalidValue, String message) {
            Assert.hasText(entity, "Entity must not be null or empty");
            Assert.hasText(property, "Property must not be null or empty");
            Assert.hasText(message, "Message must not be null or empty");
            this.entity = entity;
            this.property = property;
            this.invalidValue = invalidValue;
            this.message = message;
        }

        public static ValidationError of(String entity, String property, Object invalidValue, String message) {
            return new ValidationError(entity, property, invalidValue, message);
        }

        public String getEntity() {
            return this.entity;
        }

        public String getProperty() {
            return this.property;
        }

        @Nullable
        public Object getInvalidValue() {
            return this.invalidValue;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationError)) {
                return false;
            }
            ValidationError other = (ValidationError)o;
            return Objects.equals(this.entity, other.entity) && Objects.equals(this.property, other.property) && Objects.equals(this.invalidValue, other.invalidValue) && Objects.equals(this.message, other.message);
        }

        public int hashCode() {
            return Objects.hash(this.entity, this.property, this.invalidValue, this.message);
        }

        public String toString() {
            return "RepositoryConstraintViolationExceptionMessage.ValidationError(entity=" + this.entity + ", property=" + this.property + ", invalidValue=" + String.valueOf(this.invalidValue) + ", message=" + this.message + ")";
        }
    }
}

