/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.util;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.hateoas.server.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.server.core.UriMapping;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public abstract class UriUtils {
    private static AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);

    private UriUtils() {
    }

    public static String findMappingVariable(String variable, Method method, String lookupPath) {
        Assert.hasText(variable, "Variable name must not be null or empty");
        Assert.notNull((Object)method, "Method must not be null");
        UriMapping mapping = DISCOVERER.getUriMapping(method);
        return new UriTemplate(mapping.getMapping()).match(lookupPath).get(variable);
    }

    public static List<String> getPathSegments(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        UriMapping mapping = DISCOVERER.getUriMapping(method.getDeclaringClass(), method);
        return UriComponentsBuilder.fromPath(mapping.getMapping()).build().getPathSegments();
    }
}

