/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import java.util.List;
import java.util.function.LongSupplier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public abstract class PageableExecutionUtils {
    private PageableExecutionUtils() {
    }

    public static <T> Page<T> getPage(List<T> content, Pageable pageable, LongSupplier totalSupplier) {
        Assert.notNull(content, "Content must not be null");
        Assert.notNull((Object)pageable, "Pageable must not be null");
        Assert.notNull((Object)totalSupplier, "TotalSupplier must not be null");
        if (pageable.isUnpaged()) {
            return new PageImpl<T>(content, pageable, content.size());
        }
        if (PageableExecutionUtils.isPartialPage(content, pageable)) {
            if (PageableExecutionUtils.isFirstPage(pageable)) {
                return new PageImpl<T>(content, pageable, content.size());
            }
            if (!content.isEmpty()) {
                return new PageImpl<T>(content, pageable, pageable.getOffset() + (long)content.size());
            }
        }
        return new PageImpl<T>(content, pageable, totalSupplier.getAsLong());
    }

    private static <T> boolean isPartialPage(List<T> content, Pageable pageable) {
        return pageable.getPageSize() > content.size();
    }

    private static boolean isFirstPage(Pageable pageable) {
        return pageable.getOffset() == 0L;
    }
}

