/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class WindowIterator<T>
implements Iterator<T> {
    private final Function<ScrollPosition, Window<T>> windowFunction;
    private ScrollPosition currentPosition;
    @Nullable
    private Window<T> currentWindow;
    @Nullable
    private Iterator<T> currentIterator;

    public static <T> WindowIteratorBuilder<T> of(Function<ScrollPosition, Window<T>> windowFunction) {
        return new WindowIteratorBuilder<T>(windowFunction);
    }

    WindowIterator(Function<ScrollPosition, Window<T>> windowFunction, ScrollPosition position) {
        this.windowFunction = windowFunction;
        this.currentPosition = position;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currentWindow == null) {
                this.currentWindow = this.windowFunction.apply(this.currentPosition);
            }
            if (this.currentIterator == null && this.currentWindow != null) {
                Iterator<T> iterator2 = this.currentIterator = WindowIterator.isBackwardsScrolling(this.currentPosition) ? new ReverseListIterator<T>(this.currentWindow.getContent()) : this.currentWindow.iterator();
            }
            if (this.currentIterator == null) break;
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentWindow == null || !this.currentWindow.hasNext()) break;
            this.currentPosition = WindowIterator.getNextPosition(this.currentPosition, this.currentWindow);
            this.currentIterator = null;
            this.currentWindow = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    private static ScrollPosition getNextPosition(ScrollPosition currentPosition, Window<?> window) {
        if (WindowIterator.isBackwardsScrolling(currentPosition)) {
            return window.positionAt(0);
        }
        return window.positionAt(window.size() - 1);
    }

    private static boolean isBackwardsScrolling(ScrollPosition position) {
        boolean bl;
        if (position instanceof KeysetScrollPosition) {
            KeysetScrollPosition ksp = (KeysetScrollPosition)position;
            bl = ksp.scrollsBackward();
        } else {
            bl = false;
        }
        return bl;
    }

    public static class WindowIteratorBuilder<T> {
        private final Function<ScrollPosition, Window<T>> windowFunction;

        WindowIteratorBuilder(Function<ScrollPosition, Window<T>> windowFunction) {
            Assert.notNull(windowFunction, "WindowFunction must not be null");
            this.windowFunction = windowFunction;
        }

        public WindowIterator<T> startingAt(ScrollPosition position) {
            Assert.notNull((Object)position, "ScrollPosition must not be null");
            return new WindowIterator<T>(this.windowFunction, position);
        }
    }

    private static class ReverseListIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> delegate;

        public ReverseListIterator(List<T> list) {
            this.delegate = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T next() {
            return this.delegate.previous();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

