/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationDetectionMethodCallback<A extends Annotation>
implements ReflectionUtils.MethodCallback {
    private static final String MULTIPLE_FOUND = "Found annotation %s both on %s and %s; Make sure only one of them is annotated with it";
    private final boolean enforceUniqueness;
    private final Class<A> annotationType;
    @Nullable
    private Method foundMethod;
    @Nullable
    private A annotation;

    public AnnotationDetectionMethodCallback(Class<A> annotationType) {
        this(annotationType, false);
    }

    public AnnotationDetectionMethodCallback(Class<A> annotationType, boolean enforceUniqueness) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        this.annotationType = annotationType;
        this.enforceUniqueness = enforceUniqueness;
    }

    @Nullable
    public Method getMethod() {
        return this.foundMethod;
    }

    public Method getRequiredMethod() {
        Method method = this.foundMethod;
        if (method == null) {
            throw new IllegalStateException(String.format("No method with annotation %s found", this.annotationType));
        }
        return method;
    }

    @Nullable
    public A getAnnotation() {
        return this.annotation;
    }

    public boolean hasFoundAnnotation() {
        return this.annotation != null;
    }

    @Override
    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        if (this.foundMethod != null && !this.enforceUniqueness) {
            return;
        }
        A foundAnnotation = AnnotatedElementUtils.findMergedAnnotation(method, this.annotationType);
        if (foundAnnotation != null) {
            if (this.foundMethod != null && this.enforceUniqueness) {
                throw new IllegalStateException(String.format(MULTIPLE_FOUND, foundAnnotation.getClass().getName(), this.foundMethod, method));
            }
            this.annotation = foundAnnotation;
            this.foundMethod = method;
        }
    }

    @Nullable
    public <T> T invoke(@Nullable Object target, Object ... args2) {
        Method method = this.foundMethod;
        if (method == null) {
            return null;
        }
        ReflectionUtils.makeAccessible(method);
        return (T)ReflectionUtils.invokeMethod(method, target, args2);
    }
}

