/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.function.Consumer;
import org.springframework.lang.Nullable;

public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static void ifPresent(String className, @Nullable ClassLoader classLoader, Consumer<Class<?>> action) {
        try {
            Class<?> theClass = org.springframework.util.ClassUtils.forName(className, classLoader);
            action.accept(theClass);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    public static Class<?> loadIfPresent(String name, @Nullable ClassLoader classLoader) {
        try {
            return org.springframework.util.ClassUtils.forName(name, classLoader);
        }
        catch (Exception o_O) {
            return null;
        }
    }
}

