/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.util.CustomCollectionRegistrar;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CustomCollections {
    private static final java.util.Set<Class<?>> CUSTOM_TYPES;
    private static final java.util.Set<Class<?>> CUSTOM_MAP_TYPES;
    private static final java.util.Set<Class<?>> CUSTOM_COLLECTION_TYPES;
    private static final java.util.Set<Class<?>> PAGINATION_RETURN_TYPES;
    private static final java.util.Set<Class<?>> COLLECTIONS_AND_MAP;
    private static final SearchableTypes MAP_TYPES;
    private static final SearchableTypes COLLECTION_TYPES;
    private static final Collection<CustomCollectionRegistrar> REGISTRARS;

    public static java.util.Set<Class<?>> getCustomTypes() {
        return CUSTOM_TYPES;
    }

    public static java.util.Set<Class<?>> getPaginationReturnTypes() {
        return PAGINATION_RETURN_TYPES;
    }

    public static boolean isMapBaseType(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        return MAP_TYPES.has(type);
    }

    public static Class<?> getMapBaseType(Class<?> type) throws IllegalArgumentException {
        return MAP_TYPES.getSuperType(type);
    }

    public static boolean isMap(Class<?> type) {
        return MAP_TYPES.hasSuperTypeFor(type);
    }

    public static boolean isCollection(Class<?> type) {
        return COLLECTION_TYPES.hasSuperTypeFor(type);
    }

    public static java.util.Set<Function<Object, Object>> getUnwrappers() {
        return REGISTRARS.stream().map(CustomCollectionRegistrar::toJavaNativeCollection).collect(Collectors.toUnmodifiableSet());
    }

    public static void registerConvertersIn(ConverterRegistry registry) {
        Assert.notNull((Object)registry, "ConverterRegistry must not be null");
        REGISTRARS.forEach(it -> it.registerConvertersIn(registry));
    }

    private static void registerCollectionType(Class<?> type) {
        CUSTOM_TYPES.add(type);
        CUSTOM_COLLECTION_TYPES.add(type);
    }

    private static void registerMapType(Class<?> type) {
        CUSTOM_TYPES.add(type);
        CUSTOM_MAP_TYPES.add(type);
    }

    static {
        COLLECTIONS_AND_MAP = java.util.Set.of(Collection.class, List.class, java.util.Set.class, Map.class);
        CUSTOM_TYPES = new HashSet();
        PAGINATION_RETURN_TYPES = new HashSet();
        CUSTOM_MAP_TYPES = new HashSet();
        CUSTOM_COLLECTION_TYPES = new HashSet();
        REGISTRARS = SpringFactoriesLoader.loadFactories(CustomCollectionRegistrar.class, CustomCollections.class.getClassLoader()).stream().filter(CustomCollectionRegistrar::isAvailable).toList();
        REGISTRARS.forEach(it -> {
            it.getCollectionTypes().forEach(CustomCollections::registerCollectionType);
            it.getMapTypes().forEach(CustomCollections::registerMapType);
            it.getAllowedPaginationReturnTypes().forEach(PAGINATION_RETURN_TYPES::add);
        });
        MAP_TYPES = new SearchableTypes(CUSTOM_MAP_TYPES, Map.class);
        COLLECTION_TYPES = new SearchableTypes(CUSTOM_COLLECTION_TYPES, Collection.class);
    }

    private static class SearchableTypes {
        private static final BiPredicate<Class<?>, Class<?>> EQUALS = (left, right) -> left.equals(right);
        private static final BiPredicate<Class<?>, Class<?>> IS_ASSIGNABLE = (left, right) -> left.isAssignableFrom((Class<?>)right);
        private static final Function<Class<?>, Boolean> IS_NOT_NULL = it -> it != null;
        private final Collection<Class<?>> types;

        public SearchableTypes(java.util.Set<Class<?>> types, Class<?> ... additional) {
            ArrayList all = new ArrayList(List.of(additional));
            all.addAll(types);
            this.types = all;
        }

        public boolean hasSuperTypeFor(Class<?> type) {
            Assert.notNull(type, "Type must not be null");
            return this.isOneOf(type, IS_ASSIGNABLE, IS_NOT_NULL);
        }

        public boolean has(Class<?> type) {
            Assert.notNull(type, "Type must not be null");
            return this.isOneOf(type, EQUALS, IS_NOT_NULL);
        }

        public Class<?> getSuperType(Class<?> type) {
            Assert.notNull(type, "Type must not be null");
            Supplier<String> message = () -> String.format("Type %s not contained in candidates %s", type, this.types);
            return this.isOneOf(type, (l, r) -> l.isAssignableFrom((Class<?>)r), SearchableTypes.rejectNull(message));
        }

        private <T> T isOneOf(Class<?> type, BiPredicate<Class<?>, Class<?>> matcher, Function<Class<?>, T> resultMapper) {
            for (Class<?> candidate : this.types) {
                if (!matcher.test(candidate, type)) continue;
                return resultMapper.apply(candidate);
            }
            return resultMapper.apply(null);
        }

        private static Function<Class<?>, Class<?>> rejectNull(Supplier<String> message) {
            Assert.notNull(message, "Message must not be null");
            return candidate -> {
                if (candidate == null) {
                    throw new IllegalArgumentException((String)message.get());
                }
                return candidate;
            };
        }
    }

    static class EclipseCollections
    implements CustomCollectionRegistrar {
        EclipseCollections() {
        }

        @Override
        public boolean isAvailable() {
            return ClassUtils.isPresent("org.eclipse.collections.api.list.ImmutableList", EclipseCollections.class.getClassLoader());
        }

        @Override
        public Collection<Class<?>> getCollectionTypes() {
            return List.of(ImmutableList.class, ImmutableSet.class, ImmutableBag.class, MutableList.class, MutableSet.class, MutableBag.class);
        }

        @Override
        public Collection<Class<?>> getMapTypes() {
            return List.of(ImmutableMap.class, MutableMap.class);
        }

        @Override
        public Collection<Class<?>> getAllowedPaginationReturnTypes() {
            return List.of(ImmutableList.class, MutableList.class);
        }

        @Override
        public Function<Object, Object> toJavaNativeCollection() {
            return source2 -> source2 instanceof RichIterable ? EclipseToJavaConverter.INSTANCE.convert(source2) : source2;
        }

        @Override
        public void registerConvertersIn(ConverterRegistry registry) {
            registry.addConverter(EclipseToJavaConverter.INSTANCE);
            registry.addConverter(JavaToEclipseConverter.INSTANCE);
        }

        static enum EclipseToJavaConverter implements Converter<Object, Object>,
        ConditionalConverter
        {
            INSTANCE;

            private static final TypeDescriptor RICH_ITERABLE_DESCRIPTOR;

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                return sourceType.isAssignableTo(RICH_ITERABLE_DESCRIPTOR) && COLLECTIONS_AND_MAP.contains(targetType.getType());
            }

            @Override
            @Nullable
            public Object convert(@Nullable Object source2) {
                if (source2 instanceof ImmutableList) {
                    return ((ImmutableList)source2).toList();
                }
                if (source2 instanceof ImmutableBag) {
                    return ((ImmutableBag)source2).toList();
                }
                if (source2 instanceof ImmutableSet) {
                    return ((ImmutableSet)source2).toSet();
                }
                if (source2 instanceof ImmutableMap) {
                    return ((ImmutableMap)source2).toMap();
                }
                return source2;
            }

            static {
                RICH_ITERABLE_DESCRIPTOR = TypeDescriptor.valueOf(RichIterable.class);
            }
        }

        static enum JavaToEclipseConverter implements ConditionalGenericConverter
        {
            INSTANCE;

            private static final java.util.Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;

            @Override
            @NonNull
            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && MapIterable.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || MapIterable.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(RichIterable.class);
            }

            @Override
            @Nullable
            public Object convert(@Nullable Object source2, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
                Class<?> targetType = targetDescriptor.getType();
                if (ImmutableList.class.isAssignableFrom(targetType)) {
                    return Lists.immutable.ofAll((Iterable)source2);
                }
                if (ImmutableSet.class.isAssignableFrom(targetType)) {
                    return Sets.immutable.ofAll((Iterable)source2);
                }
                if (ImmutableBag.class.isAssignableFrom(targetType)) {
                    return Bags.immutable.ofAll((Iterable)source2);
                }
                if (ImmutableMap.class.isAssignableFrom(targetType)) {
                    return Maps.immutable.ofAll((Map)source2);
                }
                if (MutableList.class.isAssignableFrom(targetType)) {
                    return Lists.mutable.ofAll((Iterable)source2);
                }
                if (MutableSet.class.isAssignableFrom(targetType)) {
                    return Sets.mutable.ofAll((Iterable)source2);
                }
                if (MutableBag.class.isAssignableFrom(targetType)) {
                    return Bags.mutable.ofAll((Iterable)source2);
                }
                if (MutableMap.class.isAssignableFrom(targetType)) {
                    return Maps.mutable.ofMap((Map)source2);
                }
                if (source2 instanceof List) {
                    return Lists.mutable.ofAll((Iterable)source2);
                }
                if (source2 instanceof java.util.Set) {
                    return Sets.mutable.ofAll((Iterable)source2);
                }
                if (source2 instanceof Map) {
                    return Maps.mutable.ofMap((Map)source2);
                }
                return source2;
            }

            static {
                HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
                pairs.add(new GenericConverter.ConvertiblePair(Collection.class, RichIterable.class));
                pairs.add(new GenericConverter.ConvertiblePair(java.util.Set.class, MutableSet.class));
                pairs.add(new GenericConverter.ConvertiblePair(java.util.Set.class, MutableList.class));
                pairs.add(new GenericConverter.ConvertiblePair(java.util.Set.class, ImmutableSet.class));
                pairs.add(new GenericConverter.ConvertiblePair(java.util.Set.class, ImmutableList.class));
                pairs.add(new GenericConverter.ConvertiblePair(List.class, MutableList.class));
                pairs.add(new GenericConverter.ConvertiblePair(List.class, ImmutableList.class));
                pairs.add(new GenericConverter.ConvertiblePair(Map.class, RichIterable.class));
                pairs.add(new GenericConverter.ConvertiblePair(Map.class, MutableMap.class));
                pairs.add(new GenericConverter.ConvertiblePair(Map.class, ImmutableMap.class));
                CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
            }
        }
    }

    static class VavrCollections
    implements CustomCollectionRegistrar {
        private static final TypeDescriptor OBJECT_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);

        VavrCollections() {
        }

        @Override
        public boolean isAvailable() {
            return ClassUtils.isPresent("io.vavr.control.Option", VavrCollections.class.getClassLoader());
        }

        @Override
        public Collection<Class<?>> getMapTypes() {
            return java.util.Set.of(io.vavr.collection.Map.class);
        }

        @Override
        public Collection<Class<?>> getCollectionTypes() {
            return List.of(Seq.class, Set.class);
        }

        @Override
        public Collection<Class<?>> getAllowedPaginationReturnTypes() {
            return java.util.Set.of(Seq.class);
        }

        @Override
        public void registerConvertersIn(ConverterRegistry registry) {
            registry.addConverter(JavaToVavrCollectionConverter.INSTANCE);
            registry.addConverter(VavrToJavaCollectionConverter.INSTANCE);
        }

        @Override
        public Function<Object, Object> toJavaNativeCollection() {
            return source2 -> source2 instanceof Traversable ? VavrToJavaCollectionConverter.INSTANCE.convert(source2, TypeDescriptor.forObject(source2), OBJECT_DESCRIPTOR) : source2;
        }

        private static enum JavaToVavrCollectionConverter implements ConditionalGenericConverter
        {
            INSTANCE;

            private static final java.util.Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;

            @Override
            @NonNull
            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && io.vavr.collection.Map.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || io.vavr.collection.Map.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(Traversable.class);
            }

            @Override
            @Nullable
            public Object convert(@Nullable Object source2, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
                Class<?> targetType = targetDescriptor.getType();
                if (Seq.class.isAssignableFrom(targetType)) {
                    return io.vavr.collection.List.ofAll((Iterable)((Iterable)source2));
                }
                if (Set.class.isAssignableFrom(targetType)) {
                    return LinkedHashSet.ofAll((Iterable)((Iterable)source2));
                }
                if (io.vavr.collection.Map.class.isAssignableFrom(targetType)) {
                    return LinkedHashMap.ofAll((Map)((Map)source2));
                }
                if (source2 instanceof List) {
                    return io.vavr.collection.List.ofAll((Iterable)((Iterable)source2));
                }
                if (source2 instanceof java.util.Set) {
                    return LinkedHashSet.ofAll((Iterable)((Iterable)source2));
                }
                if (source2 instanceof Map) {
                    return LinkedHashMap.ofAll((Map)((Map)source2));
                }
                return source2;
            }

            static {
                HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
                pairs.add(new GenericConverter.ConvertiblePair(Collection.class, Traversable.class));
                pairs.add(new GenericConverter.ConvertiblePair(Map.class, Traversable.class));
                CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
            }
        }

        private static enum VavrToJavaCollectionConverter implements ConditionalGenericConverter
        {
            INSTANCE;

            private static final TypeDescriptor TRAVERSAL_TYPE;

            @Override
            @NonNull
            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return COLLECTIONS_AND_MAP.stream().map(it -> new GenericConverter.ConvertiblePair(Traversable.class, (Class<?>)it)).collect(Collectors.toSet());
            }

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                return sourceType.isAssignableTo(TRAVERSAL_TYPE) && COLLECTIONS_AND_MAP.contains(targetType.getType());
            }

            @Override
            @Nullable
            public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (source2 == null) {
                    return null;
                }
                if (source2 instanceof Seq) {
                    return ((Seq)source2).asJava();
                }
                if (source2 instanceof io.vavr.collection.Map) {
                    return ((io.vavr.collection.Map)source2).toJavaMap();
                }
                if (source2 instanceof Set) {
                    return ((Set)source2).toJavaSet();
                }
                throw new IllegalArgumentException("Unsupported Vavr collection " + String.valueOf(source2.getClass()));
            }

            static {
                TRAVERSAL_TYPE = TypeDescriptor.valueOf(Traversable.class);
            }
        }
    }
}

