/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeScanner;

class DelegatingTypeScanner
implements TypeScanner {
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private Collection<String> packageNames;
    private Collection<TypeFilter> includeFilters;
    private Consumer<ClassNotFoundException> classNotFoundAction;
    private Lazy<Set<Class<?>>> scanResult = Lazy.of(this::collect);

    DelegatingTypeScanner(ResourceLoader resourceLoader) {
        this(new StandardEnvironment(), resourceLoader);
    }

    DelegatingTypeScanner(Environment environment2, ResourceLoader resourceLoader) {
        this(environment2, resourceLoader, Collections.emptyList(), Collections.singleton((metadataReader, readerFactory) -> true), error -> {});
    }

    DelegatingTypeScanner(Environment environment2, ResourceLoader resourceLoader, Collection<String> packageNames, Collection<TypeFilter> includeFilters, Consumer<ClassNotFoundException> classNotFoundAction) {
        this.environment = environment2;
        this.resourceLoader = resourceLoader;
        this.packageNames = new ArrayList<String>(packageNames);
        this.includeFilters = new ArrayList<TypeFilter>(includeFilters);
        this.classNotFoundAction = classNotFoundAction;
    }

    @Override
    public TypeScanner scanPackages(Collection<String> packageNames) {
        return new DelegatingTypeScanner(this.environment, this.resourceLoader, packageNames, this.includeFilters, this.classNotFoundAction);
    }

    @Override
    public TypeScanner forTypesAnnotatedWith(Collection<Class<? extends Annotation>> annotations) {
        return new DelegatingTypeScanner(this.environment, this.resourceLoader, this.packageNames, annotations.stream().map(DelegatingTypeScanner::annotationFilter).collect(Collectors.toSet()), this.classNotFoundAction);
    }

    @Override
    public TypeScanner onClassNotFound(Consumer<ClassNotFoundException> action) {
        return new DelegatingTypeScanner(this.environment, this.resourceLoader, this.packageNames, this.includeFilters, action);
    }

    @Override
    public Set<Class<?>> collectAsSet() {
        return this.scanResult.get();
    }

    @Override
    public void forEach(Consumer<Class<?>> action) {
        this.collectAsSet().forEach(action);
    }

    private Set<Class<?>> collect() {
        AnnotatedTypeScanner annotatedTypeScanner = new AnnotatedTypeScanner(false, Collections.emptyList());
        annotatedTypeScanner.setResourceLoader(this.resourceLoader);
        annotatedTypeScanner.setEnvironment(this.environment);
        if (this.classNotFoundAction != null) {
            annotatedTypeScanner.setClassNotFoundAction(this.classNotFoundAction);
        }
        return annotatedTypeScanner.findTypes(this.packageNames, this.includeFilters);
    }

    private static AnnotationTypeFilter annotationFilter(Class<? extends Annotation> annotation) {
        return new AnnotationTypeFilter(annotation, true, false);
    }
}

