/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.springframework.core.KotlinDetector;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.util.Assert;

public interface Predicates {
    public static final Predicate<Member> IS_ENUM_MEMBER = member -> member.getDeclaringClass().isEnum();
    public static final Predicate<Member> IS_HIBERNATE_MEMBER = member -> member.getName().startsWith("$$_hibernate");
    public static final Predicate<Member> IS_OBJECT_MEMBER = member -> Object.class.equals(member.getDeclaringClass());
    public static final Predicate<Member> IS_JAVA = member -> member.getDeclaringClass().getPackageName().startsWith("java.");
    public static final Predicate<Member> IS_NATIVE = member -> Modifier.isNative(member.getModifiers());
    public static final Predicate<Member> IS_PRIVATE = member -> Modifier.isPrivate(member.getModifiers());
    public static final Predicate<Member> IS_PROTECTED = member -> Modifier.isProtected(member.getModifiers());
    public static final Predicate<Member> IS_PUBLIC = member -> Modifier.isPublic(member.getModifiers());
    public static final Predicate<Member> IS_SYNTHETIC = Member::isSynthetic;
    public static final Predicate<Class<?>> IS_KOTLIN = KotlinDetector.isKotlinPresent() ? KotlinReflectionUtils::isSupportedKotlinClass : type -> false;
    public static final Predicate<Member> IS_STATIC = member -> Modifier.isStatic(member.getModifiers());
    public static final Predicate<Method> IS_BRIDGE_METHOD = Method::isBridge;

    public static <T> Predicate<T> isTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> isFalse() {
        return t -> false;
    }

    public static <T> Predicate<T> negate(Predicate<T> predicate) {
        Assert.notNull(predicate, "Predicate must not be null");
        return predicate.negate();
    }

    public static boolean isIncluded(Constructor<?> candidate) {
        return !Predicates.isExcluded(candidate);
    }

    public static boolean isExcluded(Constructor<?> candidate) {
        if (IS_KOTLIN.test(candidate.getDeclaringClass())) {
            return false;
        }
        return IS_SYNTHETIC.test(candidate);
    }
}

