/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.util.ClassUtils;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return Arrays.asList(method.getParameterTypes()).contains(type);
    }

    public static boolean hasParameterAssignableToType(Method method, Class<?> type) {
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (!type.isAssignableFrom(parameterType)) continue;
            return true;
        }
        return false;
    }

    public static int getParameterCount(Method method, Predicate<Class<?>> predicate) {
        return (int)Arrays.stream(method.getParameterTypes()).filter(predicate).count();
    }

    @Deprecated(since="3.5", forRemoval=true)
    public static <T> T createInstanceIfPresent(String classname, T defaultInstance) {
        try {
            Class<?> type = org.springframework.util.ClassUtils.forName(classname, org.springframework.util.ClassUtils.getDefaultClassLoader());
            return (T)BeanUtils.instantiateClass(type);
        }
        catch (Exception e) {
            return defaultInstance;
        }
    }

    public static boolean isVoid(Class<?> type) {
        if (type == Void.class || Void.TYPE == type) {
            return true;
        }
        return type.getName().equals("kotlin.Unit");
    }

    @Nullable
    public static Field findField(Class<?> type, final ReflectionUtils.FieldFilter filter2) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            @Override
            public boolean matches(Field field) {
                return filter2.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter2.toString());
            }
        }, false);
    }

    @Nullable
    public static Field findField(Class<?> type, DescribedFieldFilter filter2) {
        return ReflectionUtils.findField(type, filter2, true);
    }

    @Nullable
    public static Field findField(Class<?> type, DescribedFieldFilter filter2, boolean enforceUniqueness) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull((Object)filter2, "Filter must not be null");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter2.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null) {
                    throw new IllegalStateException(filter2.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    @Deprecated(since="3.5", forRemoval=true)
    public static Field findRequiredField(Class<?> type, String name) {
        return ReflectionUtils.getRequiredField(type, name);
    }

    public static Field getRequiredField(Class<?> type, String name) {
        Field result = org.springframework.util.ReflectionUtils.findField(type, name);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to find field %s on %s", name, type));
        }
        return result;
    }

    public static void setField(Field field, Object target, @Nullable Object value) {
        org.springframework.util.ReflectionUtils.makeAccessible(field);
        org.springframework.util.ReflectionUtils.setField(field, target, value);
    }

    @Deprecated
    public static Optional<Constructor<?>> findConstructor(Class<?> type, Object ... constructorArguments) {
        Assert.notNull(type, "Target type must not be null");
        Assert.notNull((Object)constructorArguments, "Constructor arguments must not be null");
        return Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> ReflectionUtils.argumentsMatch(constructor.getParameterTypes(), constructorArguments)).findFirst();
    }

    @Deprecated
    public static Method findRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return ReflectionUtils.getRequiredMethod(type, name, parameterTypes);
    }

    public static Method getRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        Assert.notNull(type, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        Method result = null;
        for (Class<?> searchType = type; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : org.springframework.util.ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || !ReflectionUtils.hasSameParams(method, parameterTypes) || result != null && !result.isSynthetic() && !result.isBridge()) continue;
                result = method;
            }
        }
        if (result == null) {
            String parameterTypeNames = Arrays.stream(parameterTypes).map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Unable to find method %s(%s) on %s", name, parameterTypeNames, type));
        }
        return result;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Stream<Class<?>> returnTypeAndParameters(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        Stream<Class<?>> returnType = Stream.of(method.getReturnType());
        Stream<Class<?>> parameterTypes = Arrays.stream(method.getParameterTypes());
        return Stream.concat(returnType, parameterTypes);
    }

    @Deprecated(since="3.5", forRemoval=true)
    public static Optional<Method> getMethod(Class<?> type, String name, ResolvableType ... parameterTypes) {
        return Optional.ofNullable(ReflectionUtils.findMethod(type, name, parameterTypes));
    }

    @Nullable
    public static Method findMethod(Class<?> type, String name, ResolvableType ... parameterTypes) {
        Assert.notNull(type, "Type must not be null");
        Assert.hasText(name, "Name must not be null or empty");
        Assert.notNull((Object)parameterTypes, "Parameter types must not be null");
        ArrayList collect = parameterTypes.length == 0 ? Collections.emptyList() : new ArrayList(parameterTypes.length);
        for (ResolvableType parameterType : parameterTypes) {
            Class<?> rawClass = parameterType.getRawClass();
            collect.add(rawClass);
        }
        Method method = org.springframework.util.ReflectionUtils.findMethod(type, name, collect.toArray(new Class[0]));
        if (method != null) {
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                if (ResolvableType.forMethodParameter(method, i2).equals(parameterTypes[i2])) continue;
                return null;
            }
            return method;
        }
        return null;
    }

    private static boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !org.springframework.util.ClassUtils.isAssignableValue(argumentType, argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isNullable(MethodParameter parameter) {
        if (ReflectionUtils.isVoid(parameter.getParameterType())) {
            return true;
        }
        if (KotlinDetector.isKotlinPresent() && KotlinReflectionUtils.isSupportedKotlinClass(parameter.getDeclaringClass())) {
            return KotlinReflectionUtils.isNullable(parameter);
        }
        return !parameter.getParameterType().isPrimitive();
    }

    public static Object getPrimitiveDefault(Class<?> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(String.format("Primitive type %s not supported", type));
    }

    @Nullable
    @Deprecated(since="3.5", forRemoval=true)
    public static Class<?> loadIfPresent(String name, ClassLoader classLoader) {
        return ClassUtils.loadIfPresent(name, classLoader);
    }

    public static interface DescribedFieldFilter
    extends ReflectionUtils.FieldFilter {
        public String getDescription();
    }

    public static class AnnotationFieldFilter
    implements DescribedFieldFilter {
        private final Class<? extends Annotation> annotationType;

        public AnnotationFieldFilter(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public boolean matches(Field field) {
            return AnnotationUtils.getAnnotation(field, this.annotationType) != null;
        }

        @Override
        public String getDescription() {
            return String.format("Annotation filter for %s", this.annotationType.getName());
        }
    }
}

