/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.util.DelegatingTypeScanner;
import org.springframework.util.Assert;

public interface TypeScanner {
    public static TypeScanner typeScanner(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "ClassLoader must not be null!");
        return TypeScanner.typeScanner(new DefaultResourceLoader(classLoader));
    }

    public static TypeScanner typeScanner(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null!");
        return new DelegatingTypeScanner(resourceLoader);
    }

    public static TypeScanner typeScanner(ApplicationContext context) {
        Assert.notNull((Object)context, "Context must not be null!");
        return new DelegatingTypeScanner(context.getEnvironment(), context);
    }

    default public TypeScanner scanPackages(String ... packageNames) {
        return this.scanPackages(Arrays.asList(packageNames));
    }

    public TypeScanner scanPackages(Collection<String> var1);

    default public TypeScanner forTypesAnnotatedWith(Class<? extends Annotation> ... annotations) {
        return this.forTypesAnnotatedWith(Arrays.asList(annotations));
    }

    public TypeScanner forTypesAnnotatedWith(Collection<Class<? extends Annotation>> var1);

    public TypeScanner onClassNotFound(Consumer<ClassNotFoundException> var1);

    default public Set<Class<?>> collectAsSet() {
        LinkedHashSet result = new LinkedHashSet();
        this.forEach(result::add);
        return result;
    }

    public void forEach(Consumer<Class<?>> var1);
}

