/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EntityModel<T>
extends RepresentationModel<EntityModel<T>> {
    private T content;

    protected EntityModel() {
        this.content = null;
    }

    protected EntityModel(T content) {
        this(content, Links.NONE);
    }

    protected EntityModel(T content, Iterable<Link> links) {
        Assert.notNull(content, "Content must not be null!");
        Assert.isTrue(!(content instanceof Collection), "Content must not be a collection! Use CollectionModel instead!");
        this.content = content;
        this.add(links);
    }

    public static <T> EntityModel<T> of(T content) {
        return EntityModel.of(content, Collections.emptyList());
    }

    public static <T> EntityModel<T> of(T content, Link ... links) {
        return EntityModel.of(content, Arrays.asList(links));
    }

    public static <T> EntityModel<T> of(T content, Iterable<Link> links) {
        return new EntityModel<T>(content, links);
    }

    @Nullable
    @JsonUnwrapped
    @JsonSerialize(using=MapSuppressingUnwrappingSerializer.class)
    public T getContent() {
        return this.content;
    }

    @Nullable
    @JsonAnyGetter
    private Map<String, Object> getMapContent() {
        return Map.class.isInstance(this.content) ? (Map)this.content : null;
    }

    @JsonAnySetter
    private void setPropertiesAsMap(String key, Object value) {
        this.getOrInitAsMap().put(key, value);
    }

    private Map<String, Object> getOrInitAsMap() {
        if (this.content == null) {
            this.content = new LinkedHashMap();
        } else {
            Assert.state(Map.class.isInstance(this.content), "Content is not a Map!");
        }
        return (Map)this.content;
    }

    @Override
    public String toString() {
        return String.format("EntityModel { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        EntityModel that = (EntityModel)obj;
        boolean contentEqual = this.content == null ? that.content == null : this.content.equals(that.content);
        return contentEqual && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * this.content.hashCode();
    }

    private static class MapSuppressingUnwrappingSerializer
    extends StdSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = -8367255762553946324L;
        @Nullable
        private final BeanProperty property;

        public MapSuppressingUnwrappingSerializer() {
            this((BeanProperty)null);
        }

        private MapSuppressingUnwrappingSerializer(@Nullable BeanProperty property) {
            super(Object.class);
            this.property = property;
        }

        @Override
        public void serialize(@Nullable Object value, @Nullable JsonGenerator gen, @NonNull SerializerProvider provider) throws IOException {
            if (value == null || Map.class.isInstance(value)) {
                return;
            }
            JsonSerializer<Object> serializer = provider.findValueSerializer(value.getClass());
            if (UnknownSerializer.class.isInstance(serializer) && !provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
                return;
            }
            if (JsonValueSerializer.class.isInstance(serializer)) {
                throw new IllegalStateException("@JsonValue rendered classes can not be directly nested in EntityModel as they do not produce a document key!");
            }
            if (ContextualSerializer.class.isInstance(serializer)) {
                serializer = ((ContextualSerializer)((Object)serializer)).createContextual(provider, this.property);
            }
            serializer.unwrappingSerializer(NameTransformer.NOP).serialize(value, gen, provider);
        }

        @Override
        public JsonSerializer<?> createContextual(@Nullable SerializerProvider prov, @Nullable BeanProperty property) throws JsonMappingException {
            return new MapSuppressingUnwrappingSerializer(property);
        }

        @Override
        public boolean isUnwrappingSerializer() {
            return true;
        }
    }
}

