/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class TemplateVariables
implements Iterable<TemplateVariable>,
Serializable {
    public static final TemplateVariables NONE = new TemplateVariables(new TemplateVariable[0]);
    private static final long serialVersionUID = -7736592281223783079L;
    private final List<TemplateVariable> variables;

    public TemplateVariables(TemplateVariable ... variables) {
        this(Arrays.asList(variables));
    }

    public TemplateVariables(List<TemplateVariable> variables) {
        Assert.notNull(variables, "Template variables must not be null!");
        Assert.noNullElements(variables.toArray(), "Variables must not contain null values!");
        boolean requestParameterFound = false;
        ArrayList<TemplateVariable> processed = new ArrayList<TemplateVariable>(variables.size());
        for (TemplateVariable variable : variables) {
            boolean isRequestParameter = variable.isRequestParameterVariable();
            processed.add(isRequestParameter && requestParameterFound ? variable.withType(TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED) : variable);
            if (!isRequestParameter) continue;
            requestParameterFound = true;
        }
        this.variables = Collections.unmodifiableList(processed);
    }

    public TemplateVariables concat(TemplateVariable ... variables) {
        return this.concat(Arrays.asList(variables));
    }

    public TemplateVariables concat(Collection<TemplateVariable> variables) {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>(this.variables.size() + variables.size());
        result.addAll(this.variables);
        for (TemplateVariable otherVariable : variables) {
            if (this.containsEquivalentFor(otherVariable)) continue;
            result.add(otherVariable);
        }
        return new TemplateVariables(result);
    }

    public TemplateVariables concat(TemplateVariables variables) {
        return this.concat(variables.variables);
    }

    public List<TemplateVariable> asList() {
        return this.variables;
    }

    public Stream<TemplateVariable> stream() {
        return this.variables.stream();
    }

    private boolean containsEquivalentFor(TemplateVariable candidate) {
        for (TemplateVariable variable : this.variables) {
            if (!variable.isEquivalent(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean appended) {
        if (this.variables.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        TemplateVariable previous = null;
        for (TemplateVariable variable : this.variables) {
            TemplateVariable.VariableType type = variable.getType();
            TemplateVariable.VariableType variableType = type = appended && type.equals((Object)TemplateVariable.VariableType.REQUEST_PARAM) ? TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED : type;
            if (previous == null) {
                builder.append("{").append(type.toString());
            } else if (!previous.isCombinable(variable)) {
                builder.append("}{").append(type.toString());
            } else {
                builder.append(",");
            }
            previous = variable;
            builder.append(variable.essence());
        }
        return builder.append("}").toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateVariables that = (TemplateVariables)o;
        return Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.variables);
    }
}

