/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.hateoas.aot.AotUtils;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ControllerMethodReturnTypeAotProcessor
implements BeanRegistrationAotProcessor {
    private final Class<? extends Annotation> controllerAnnotationType;

    public ControllerMethodReturnTypeAotProcessor() {
        this(Controller.class);
    }

    protected ControllerMethodReturnTypeAotProcessor(Class<? extends Annotation> controllerAnnotationType) {
        Assert.notNull(controllerAnnotationType, "Controller anntotation type must not be null!");
        this.controllerAnnotationType = controllerAnnotationType;
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        return AnnotatedElementUtils.isAnnotated(beanClass, this.controllerAnnotationType) ? new ProxyRegisteringAotContribution(beanClass) : null;
    }

    private static class ProxyRegisteringAotContribution
    implements BeanRegistrationAotContribution {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProxyRegisteringAotContribution.class);
        private final Class<?> beanClass;

        ProxyRegisteringAotContribution(Class<?> beanClass) {
            Assert.notNull(beanClass, "Bean class must not be null!");
            this.beanClass = beanClass;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            Class<?> proxyType = this.registerCglibProxy(this.beanClass, this.beanClass, generationContext);
            if (proxyType != null) {
                LOGGER.info("Created proxy type {} for {}", (Object)proxyType, (Object)this.beanClass);
            }
            ReflectionUtils.doWithMethods(this.beanClass, method -> {
                Class<?> returnType = method.getReturnType();
                if (ReflectionUtils.isObjectMethod(method) || method.isSynthetic() || method.isBridge() || Modifier.isPrivate(method.getModifiers()) || ClassUtils.isAssignable(returnType, Void.TYPE)) {
                    return;
                }
                RuntimeHints runtimeHints = generationContext.getRuntimeHints();
                ResolvableType methodReturnType = ResolvableType.forMethodReturnType(method);
                AotUtils.registerModelDomainTypesForReflection(methodReturnType, runtimeHints.reflection(), this.beanClass);
                if (returnType.isInterface()) {
                    runtimeHints.proxies().registerJdkProxy(returnType);
                    return;
                }
                this.registerCglibProxy(returnType, this.beanClass, generationContext);
            });
        }

        @Nullable
        private Class<?> registerCglibProxy(Class<?> type, Class<?> beanClass, GenerationContext context) {
            if (Modifier.isFinal(type.getModifiers())) {
                return null;
            }
            boolean anyNonPrivateConstructor = Arrays.stream(type.getDeclaredConstructors()).map(Constructor::getModifiers).anyMatch(Predicate.not(Modifier::isPrivate));
            if (!anyNonPrivateConstructor) {
                return null;
            }
            Class<?> result = this.createProxyClass(type, beanClass);
            if (result != null) {
                ReflectionHints reflection = context.getRuntimeHints().reflection();
                reflection.registerType(result, MemberCategory.INVOKE_DECLARED_METHODS);
                reflection.registerField(ReflectionUtils.findField(result, "CGLIB$FACTORY_DATA"));
                reflection.registerField(ReflectionUtils.findField(result, "CGLIB$CALLBACK_FILTER"));
            }
            return result;
        }

        @Nullable
        private Class<?> createProxyClass(Class<?> type, Class<?> beanClass) {
            try {
                ProxyFactory factory2 = new ProxyFactory();
                factory2.addInterface(LastInvocationAware.class);
                factory2.setProxyTargetClass(true);
                factory2.setTargetSource(EmptyTargetSource.forClass(type));
                return factory2.getProxyClass(type.getClassLoader());
            }
            catch (AopConfigException o_O) {
                LOGGER.info("Could not create proxy class for {} (via {}). Reason {}", type, beanClass, o_O.getMessage());
                return null;
            }
        }
    }
}

