/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.aot.AotUtils;
import org.springframework.hateoas.server.RepresentationModelAssembler;

class RepresentationModelAssemblerAotProcessor
implements BeanRegistrationAotProcessor {
    RepresentationModelAssemblerAotProcessor() {
    }

    @Override
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        if (!RepresentationModelAssembler.class.isAssignableFrom(beanClass)) {
            return null;
        }
        ResolvableType modelType = registeredBean.getBeanType().as(RepresentationModelAssembler.class).getGeneric(1);
        return (context, code) -> {
            ReflectionHints reflection = context.getRuntimeHints().reflection();
            AotUtils.registerModelDomainTypesForReflection(modelType, reflection, beanClass);
        };
    }
}

