/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class Hop {
    private final String rel;
    private final Map<String, Object> parameters;
    private final HttpHeaders headers;

    private Hop(String rel, Map<String, Object> parameters, HttpHeaders headers) {
        this.rel = rel;
        this.parameters = parameters;
        this.headers = headers;
    }

    public static Hop rel(String rel) {
        Assert.hasText(rel, "Relation must not be null or empty!");
        return new Hop(rel, Collections.emptyMap(), HttpHeaders.EMPTY);
    }

    public Hop withParameter(String name, Object value) {
        Assert.hasText(name, "Name must not be null or empty!");
        HashMap<String, Object> parameters = new HashMap<String, Object>(this.parameters);
        parameters.put(name, value);
        return new Hop(this.rel, parameters, this.headers);
    }

    public Hop withParameters(Map<String, Object> parameters) {
        return this.parameters == parameters ? this : new Hop(this.rel, parameters, this.headers);
    }

    public Hop withHeaders(HttpHeaders headers) {
        return this.headers == headers ? this : new Hop(this.rel, this.parameters, headers);
    }

    public Hop header(String headerName, String headerValue) {
        Assert.hasText(headerName, "headerName must not be null or empty!");
        if (this.headers == HttpHeaders.EMPTY) {
            HttpHeaders newHeaders = new HttpHeaders();
            newHeaders.add(headerName, headerValue);
            return new Hop(this.rel, this.parameters, newHeaders);
        }
        this.headers.add(headerName, headerValue);
        return this;
    }

    boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    Map<String, Object> getMergedParameters(Map<String, Object> globalParameters) {
        Assert.notNull(globalParameters, "Global parameters must not be null!");
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>();
        mergedParameters.putAll(globalParameters);
        mergedParameters.putAll(this.parameters);
        return mergedParameters;
    }

    String getRel() {
        return this.rel;
    }

    Map<String, Object> getParameters() {
        return this.parameters;
    }

    HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hop hop = (Hop)o;
        return Objects.equals(this.rel, hop.rel) && Objects.equals(this.parameters, hop.parameters) && Objects.equals(this.headers, hop.headers);
    }

    public int hashCode() {
        return Objects.hash(this.rel, this.parameters, this.headers);
    }

    public String toString() {
        return "Hop(rel=" + this.rel + ", parameters=" + String.valueOf(this.parameters) + ", headers=" + String.valueOf(this.headers) + ")";
    }
}

