/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.client.Hop;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.client.Rels;
import org.springframework.hateoas.client.TraversonDefaults;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class Traverson {
    private static final TraversonDefaults DEFAULTS;
    private final URI baseUri;
    private final List<MediaType> mediaTypes;
    private RestOperations operations;
    private LinkDiscoverers discoverers;

    public Traverson(URI baseUri, MediaType ... mediaTypes) {
        this(baseUri, Arrays.asList(mediaTypes));
    }

    public Traverson(URI baseUri, List<MediaType> mediaTypes) {
        Assert.notNull((Object)baseUri, "Base URI must not be null!");
        Assert.notEmpty(mediaTypes, "At least one media type must be given!");
        this.mediaTypes = mediaTypes;
        this.baseUri = baseUri;
        this.setLinkDiscoverers(DEFAULTS.getLinkDiscoverers(mediaTypes));
        this.setRestOperations(Traverson.createDefaultTemplate(this.mediaTypes));
    }

    public static List<HttpMessageConverter<?>> getDefaultMessageConverters(MediaType ... mediaTypes) {
        return DEFAULTS.getHttpMessageConverters(Arrays.asList(mediaTypes));
    }

    private static RestOperations createDefaultTemplate(List<MediaType> mediaTypes) {
        RestTemplate template = new RestTemplate();
        template.setMessageConverters(DEFAULTS.getHttpMessageConverters(mediaTypes));
        return template;
    }

    public Traverson setRestOperations(@Nullable RestOperations operations) {
        this.operations = operations == null ? Traverson.createDefaultTemplate(this.mediaTypes) : operations;
        return this;
    }

    public Traverson setLinkDiscoverers(@Nullable List<? extends LinkDiscoverer> discoverer) {
        List<? extends LinkDiscoverer> defaultedDiscoverers = discoverer == null ? DEFAULTS.getLinkDiscoverers(this.mediaTypes) : discoverer;
        this.discoverers = new LinkDiscoverers(PluginRegistry.of(defaultedDiscoverers));
        return this;
    }

    public TraversalBuilder follow(String ... rels) {
        return new TraversalBuilder().follow(rels);
    }

    public TraversalBuilder follow(Hop hop) {
        return new TraversalBuilder().follow(hop);
    }

    private HttpEntity<?> prepareRequest(HttpHeaders headers) {
        HttpHeaders toSend = new HttpHeaders();
        toSend.putAll(headers);
        if (headers.getAccept().isEmpty()) {
            toSend.setAccept(this.mediaTypes);
        }
        return new HttpEntity(toSend);
    }

    static {
        List<TraversonDefaults> ALL_DEFAULTS = SpringFactoriesLoader.loadFactories(TraversonDefaults.class, Traverson.class.getClassLoader());
        Assert.isTrue(ALL_DEFAULTS.size() == 1, () -> String.format("Expected to find only one TraversonDefaults instance, but found: %s", ALL_DEFAULTS.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "))));
        DEFAULTS = ALL_DEFAULTS.get(0);
    }

    public class TraversalBuilder {
        private static final String MEDIA_TYPE_HEADER_NOT_FOUND = "Response for request to %s did not expose a content type! Unable to identify links!";
        private static final String LINK_NOT_FOUND = "Expected to find link with rel '%s' in response %s!";
        private final List<Hop> rels = new ArrayList<Hop>();
        private Map<String, Object> templateParameters = new HashMap<String, Object>();
        private HttpHeaders headers = new HttpHeaders();

        private TraversalBuilder() {
        }

        public TraversalBuilder follow(String ... rels) {
            Assert.notNull((Object)rels, "Rels must not be null!");
            Arrays.stream(rels).map(Hop::rel).forEach(this.rels::add);
            return this;
        }

        public TraversalBuilder follow(Hop hop) {
            Assert.notNull((Object)hop, "Hop must not be null!");
            this.rels.add(hop);
            return this;
        }

        public TraversalBuilder withTemplateParameters(Map<String, Object> parameters) {
            Assert.notNull(parameters, "Parameters must not be null!");
            this.templateParameters = parameters;
            return this;
        }

        public TraversalBuilder withHeaders(HttpHeaders headers) {
            Assert.notNull((Object)headers, "Headers must not be null!");
            this.headers = headers;
            return this;
        }

        @Nullable
        public <T> T toObject(Class<T> type) {
            Assert.notNull(type, "Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity<?> requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type).getBody();
        }

        @Nullable
        public <T> T toObject(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, "Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity<?> requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type).getBody();
        }

        public <T> T toObject(String jsonPath) {
            Assert.hasText(jsonPath, "JSON path must not be null or empty!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity<?> requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            String forObject = (String)Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, String.class).getBody();
            return JsonPath.read(forObject, jsonPath, new Predicate[0]);
        }

        public <T> ResponseEntity<T> toEntity(Class<T> type) {
            Assert.notNull(type, "Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity<?> requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type);
        }

        public Link asLink() {
            return this.traverseToLink(true);
        }

        public Link asTemplatedLink() {
            return this.traverseToLink(false);
        }

        private Link traverseToLink(boolean expandFinalUrl) {
            Assert.isTrue(this.rels.size() > 0, "At least one rel needs to be provided!");
            return Link.of(expandFinalUrl ? this.traverseToExpandedFinalUrl().getUri().toString() : this.traverseToFinalUrl().getUri(), this.rels.get(this.rels.size() - 1).getRel());
        }

        private UriStringAndHeaders traverseToFinalUrl() {
            UriStringAndHeaders uriAndHeaders = this.getAndFindLinkWithRel(Traverson.this.baseUri.toString(), this.rels.iterator(), HttpHeaders.EMPTY);
            return new UriStringAndHeaders(UriTemplate.of(uriAndHeaders.getUri()).toString(), uriAndHeaders.getHttpHeaders());
        }

        private URIAndHeaders traverseToExpandedFinalUrl() {
            UriStringAndHeaders uriAndHeaders = this.getAndFindLinkWithRel(Traverson.this.baseUri.toString(), this.rels.iterator(), HttpHeaders.EMPTY);
            return new URIAndHeaders(UriTemplate.of(uriAndHeaders.getUri()).expand(this.templateParameters), uriAndHeaders.getHttpHeaders());
        }

        private UriStringAndHeaders getAndFindLinkWithRel(String uri, Iterator<Hop> rels, HttpHeaders extraHeaders) {
            if (!rels.hasNext()) {
                return new UriStringAndHeaders(uri, extraHeaders);
            }
            HttpEntity<?> request = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, extraHeaders));
            URI target = UriTemplate.of(uri).expand(new Object[0]);
            ResponseEntity<String> responseEntity = Traverson.this.operations.exchange(target, HttpMethod.GET, request, String.class);
            MediaType contentType = responseEntity.getHeaders().getContentType();
            if (contentType == null) {
                throw new IllegalStateException(String.format(MEDIA_TYPE_HEADER_NOT_FOUND, target));
            }
            String responseBody = (String)responseEntity.getBody();
            Hop thisHop = rels.next();
            Rels.Rel rel = Rels.getRelFor(thisHop.getRel(), Traverson.this.discoverers);
            Link link = rel.findInResponse(responseBody == null ? "" : responseBody, contentType).orElseThrow(() -> new IllegalStateException(String.format(LINK_NOT_FOUND, rel, responseBody)));
            String linkTarget = thisHop.hasParameters() ? link.expand(thisHop.getMergedParameters(this.templateParameters)).getHref() : link.getHref();
            return this.getAndFindLinkWithRel(linkTarget, rels, thisHop.getHeaders());
        }

        private HttpHeaders mergeHeaders(HttpHeaders headersA, HttpHeaders headersB) {
            HttpHeaders mergedHeaders = new HttpHeaders();
            mergedHeaders.addAll(headersA);
            mergedHeaders.addAll(headersB);
            return mergedHeaders;
        }
    }

    private static final class URIAndHeaders {
        private final URI uri;
        private final HttpHeaders httpHeaders;

        URIAndHeaders(URI uri, HttpHeaders httpHeaders) {
            this.uri = uri;
            this.httpHeaders = httpHeaders;
        }

        URI getUri() {
            return this.uri;
        }

        HttpHeaders getHttpHeaders() {
            return this.httpHeaders;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URIAndHeaders that = (URIAndHeaders)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.httpHeaders, that.httpHeaders);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.httpHeaders);
        }

        public String toString() {
            return "Traverson.URIAndHeaders(uri=" + String.valueOf(this.uri) + ", httpHeaders=" + String.valueOf(this.httpHeaders) + ")";
        }
    }

    private static final class UriStringAndHeaders {
        private final String uri;
        private final HttpHeaders httpHeaders;

        UriStringAndHeaders(String uri, HttpHeaders httpHeaders) {
            this.uri = uri;
            this.httpHeaders = httpHeaders;
        }

        String getUri() {
            return this.uri;
        }

        HttpHeaders getHttpHeaders() {
            return this.httpHeaders;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UriStringAndHeaders that = (UriStringAndHeaders)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.httpHeaders, that.httpHeaders);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.httpHeaders);
        }

        public String toString() {
            return "Traverson.UriStringAndHeaders(uri=" + this.uri + ", httpHeaders=" + String.valueOf(this.httpHeaders) + ")";
        }
    }
}

