/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.config.HypermediaRestTemplateConfigurer;
import org.springframework.hateoas.config.WebConverters;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
class RestTemplateHateoasConfiguration {
    RestTemplateHateoasConfiguration() {
    }

    @Bean
    static HypermediaRestTemplateBeanPostProcessor hypermediaRestTemplateBeanPostProcessor(ObjectFactory<HypermediaRestTemplateConfigurer> configurer) {
        return new HypermediaRestTemplateBeanPostProcessor(configurer);
    }

    @Bean
    @Lazy
    HypermediaRestTemplateConfigurer hypermediaRestTemplateConfigurer(WebConverters converters) {
        return new HypermediaRestTemplateConfigurer(converters);
    }

    static class HypermediaRestTemplateBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectFactory<HypermediaRestTemplateConfigurer> configurer;

        public HypermediaRestTemplateBeanPostProcessor(ObjectFactory<HypermediaRestTemplateConfigurer> configurer) {
            this.configurer = configurer;
        }

        @Override
        @NonNull
        public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
            return !RestTemplate.class.isInstance(bean2) ? bean2 : this.configurer.getObject().registerHypermediaTypes((RestTemplate)bean2);
        }
    }
}

