/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.HypermediaWebClientConfigurer;
import org.springframework.hateoas.config.WebfluxCodecCustomizer;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
class WebClientHateoasConfiguration {
    WebClientHateoasConfiguration() {
    }

    @Bean
    @Lazy
    HypermediaWebClientConfigurer webClientConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        WebfluxCodecCustomizer withGenericJsonTypes = new WebfluxCodecCustomizer(hypermediaTypes, mapper.getIfAvailable(ObjectMapper::new)).withGenericJsonTypes();
        return new HypermediaWebClientConfigurer(withGenericJsonTypes);
    }

    @Bean
    static HypermediaWebClientBeanPostProcessor webClientBeanPostProcessor(ObjectFactory<HypermediaWebClientConfigurer> configurer) {
        return new HypermediaWebClientBeanPostProcessor(configurer);
    }

    static class HypermediaWebClientBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectFactory<HypermediaWebClientConfigurer> configurer;

        public HypermediaWebClientBeanPostProcessor(ObjectFactory<HypermediaWebClientConfigurer> configurer) {
            this.configurer = configurer;
        }

        @Override
        @NonNull
        public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
            return !WebClient.class.isInstance(bean2) ? bean2 : this.configurer.getObject().registerHypermediaTypes(((WebClient)bean2).mutate()).build();
        }
    }
}

