/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class WebConverters {
    private static MediaType ANY_JSON = MediaType.parseMediaType("application/*+json");
    private final List<HypermediaMappingInformation> infos;
    private final ObjectMapper mapper;

    private WebConverters(ObjectMapper mapper, List<HypermediaMappingInformation> mappingInformation) {
        this.mapper = mapper;
        this.infos = mappingInformation;
    }

    public static WebConverters of(ObjectMapper mapper, List<HypermediaMappingInformation> mappingInformations) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null!");
        Assert.notNull(mappingInformations, "Mapping information must not be null!");
        return new WebConverters(mapper, mappingInformations);
    }

    List<MediaType> getSupportedMediaTypes() {
        return this.infos.stream().flatMap(it -> it.getMediaTypes().stream()).collect(Collectors.toList());
    }

    public void augmentServer(List<HttpMessageConverter<?>> converters) {
        this.augment(converters, false);
    }

    public void augmentClient(List<HttpMessageConverter<?>> converters) {
        this.augment(converters, true);
    }

    private void augment(List<HttpMessageConverter<?>> converters, boolean includeGenericJsonTypes) {
        Assert.notNull(converters, "HttpMessageConverters must not be null!");
        MappingJackson2HttpMessageConverter converter = converters.stream().filter(it -> MappingJackson2HttpMessageConverter.class.equals(it.getClass())).map(MappingJackson2HttpMessageConverter.class::cast).findFirst().orElseGet(() -> new MappingJackson2HttpMessageConverter(this.mapper));
        ObjectMapper first = null;
        for (HypermediaMappingInformation info : this.infos) {
            Class<?> rootType = info.getRootType();
            ObjectMapper objectMapper = info.configureObjectMapper(this.mapper.copy());
            if (first == null) {
                first = objectMapper;
            }
            Map mappers = info.getMediaTypes().stream().distinct().collect(Collectors.toMap(Function.identity(), __ -> objectMapper));
            converter.registerObjectMappersForType(rootType, map -> map.putAll(mappers));
        }
        if (!includeGenericJsonTypes || this.infos.isEmpty()) {
            return;
        }
        Class<?> rootType = this.infos.get(0).getRootType();
        ObjectMapper mapper = first;
        converter.registerObjectMappersForType(rootType, map -> Stream.of(MediaType.APPLICATION_JSON, ANY_JSON).forEach(it -> map.put(it, mapper)));
    }
}

