/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MessageSourceResolver
implements MessageResolver {
    private final MessageSourceAccessor accessor;

    MessageSourceResolver(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, "MessageSource must not be null!");
        this.accessor = new MessageSourceAccessor(messageSource);
    }

    @Override
    @Nullable
    public String resolve(MessageSourceResolvable resolvable) {
        String resolved = this.accessor.getMessage(resolvable);
        return StringUtils.hasText(resolved) ? resolved : null;
    }
}

