/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

class TypeBasedPayloadMetadata
implements AffordanceModel.InputPayloadMetadata {
    private final Class<?> type;
    private final SortedMap<String, AffordanceModel.PropertyMetadata> properties;
    private final List<MediaType> mediaTypes;

    TypeBasedPayloadMetadata(Class<?> type, Stream<AffordanceModel.PropertyMetadata> properties) {
        this(type, new TreeMap<String, AffordanceModel.PropertyMetadata>(properties.collect(Collectors.toMap(AffordanceModel.PropertyMetadata::getName, Function.identity()))), Collections.emptyList());
    }

    TypeBasedPayloadMetadata(Class<?> type, SortedMap<String, AffordanceModel.PropertyMetadata> properties, List<MediaType> mediaTypes) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull(properties, "Properties must not be null!");
        Assert.notNull(mediaTypes, "Media types must not be null!");
        this.type = type;
        this.properties = properties;
        this.mediaTypes = mediaTypes;
    }

    @Override
    public <T extends AffordanceModel.Named> T customize(T target, Function<AffordanceModel.PropertyMetadata, T> customizer2) {
        AffordanceModel.PropertyMetadata metadata = (AffordanceModel.PropertyMetadata)this.properties.get(target.getName());
        return (T)(metadata == null ? target : (AffordanceModel.Named)customizer2.apply(metadata));
    }

    @Override
    public Stream<AffordanceModel.PropertyMetadata> stream() {
        return this.properties.values().stream();
    }

    @Override
    public List<String> getI18nCodes() {
        return Arrays.asList(this.type.getName(), this.type.getSimpleName());
    }

    @Override
    @NonNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public AffordanceModel.InputPayloadMetadata withMediaTypes(List<MediaType> mediaTypes) {
        return new TypeBasedPayloadMetadata(this.type, this.properties, mediaTypes);
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeBasedPayloadMetadata)) {
            return false;
        }
        TypeBasedPayloadMetadata that = (TypeBasedPayloadMetadata)obj;
        return this.type.equals(that.type) && this.properties.equals(that.properties) && this.mediaTypes.equals(that.mediaTypes);
    }

    public int hashCode() {
        int result = 31;
        result += 17 * this.type.hashCode();
        result += 17 * this.properties.hashCode();
        return result += 17 * this.mediaTypes.hashCode();
    }
}

