/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import java.io.InputStream;
import java.util.Optional;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.JsonPathLinkDiscoverer;
import org.springframework.util.Assert;

public class CollectionJsonLinkDiscoverer
extends JsonPathLinkDiscoverer {
    private final CollectionJsonSelfLinkDiscoverer selfLinkDiscoverer = new CollectionJsonSelfLinkDiscoverer();

    public CollectionJsonLinkDiscoverer() {
        super("$.collection..links..[?(@.rel == '%s')].href", MediaTypes.COLLECTION_JSON);
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation relation, String representation) {
        Assert.notNull((Object)relation, "LinkRelation must not be null!");
        Assert.notNull((Object)representation, "Representation must not be null!");
        return relation.isSameAs(IanaLinkRelations.SELF) ? this.findSelfLink(representation) : super.findLinkWithRel(relation, representation);
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation relation, InputStream representation) {
        Assert.notNull((Object)relation, "LinkRelation must not be null!");
        Assert.notNull((Object)representation, "InputStream must not be null!");
        return relation.isSameAs(IanaLinkRelations.SELF) ? this.findSelfLink(representation) : super.findLinkWithRel(relation, representation);
    }

    @Override
    public Links findLinksWithRel(LinkRelation relation, String representation) {
        Assert.notNull((Object)relation, "LinkRelation must not be null!");
        Assert.notNull((Object)representation, "Representation must not be null!");
        return relation.isSameAs(IanaLinkRelations.SELF) ? this.addSelfLink(super.findLinksWithRel(relation, representation), representation) : super.findLinksWithRel(relation, representation);
    }

    @Override
    public Links findLinksWithRel(LinkRelation relation, InputStream representation) {
        return relation.isSameAs(IanaLinkRelations.SELF) ? this.addSelfLink(super.findLinksWithRel(relation, representation), representation) : super.findLinksWithRel(relation, representation);
    }

    private Optional<Link> findSelfLink(String representation) {
        return this.selfLinkDiscoverer.findLinkWithRel(IanaLinkRelations.SELF, representation);
    }

    private Optional<Link> findSelfLink(InputStream representation) {
        return this.selfLinkDiscoverer.findLinkWithRel(IanaLinkRelations.SELF, representation);
    }

    private Links addSelfLink(Links links, String representation) {
        return this.findSelfLink(representation).map(xva$0 -> Links.of(xva$0)).map(it -> it.and(links)).orElse(links);
    }

    private Links addSelfLink(Links links, InputStream representation) {
        return this.findSelfLink(representation).map(xva$0 -> Links.of(xva$0)).map(it -> it.and(links)).orElse(links);
    }

    private static class CollectionJsonSelfLinkDiscoverer
    extends JsonPathLinkDiscoverer {
        CollectionJsonSelfLinkDiscoverer() {
            super("$.collection.href", MediaTypes.COLLECTION_JSON);
        }
    }
}

