/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.IanaUriSchemes;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HalLinkRelation
implements LinkRelation,
MessageSourceResolvable {
    public static final HalLinkRelation CURIES = HalLinkRelation.uncuried("curies");
    private static final String RELATION_MESSAGE_TEMPLATE = "_links.%s.title";
    @Nullable
    private final String curie;
    private final String localPart;

    private HalLinkRelation(@Nullable String curie, String localPart) {
        Assert.notNull((Object)localPart, "Local part must not be null!");
        this.curie = curie;
        this.localPart = localPart;
    }

    public static HalLinkRelation of(LinkRelation relation) {
        Assert.notNull((Object)relation, "LinkRelation must not be null!");
        if (HalLinkRelation.class.isInstance(relation)) {
            return (HalLinkRelation)relation;
        }
        return HalLinkRelation.of(relation.value());
    }

    @JsonCreator
    private static HalLinkRelation of(String relation) {
        int firstColonIndex = relation.indexOf(58);
        String curie = firstColonIndex == -1 ? null : relation.substring(0, firstColonIndex);
        return curie == null || IanaUriSchemes.isIanaUriScheme(curie) ? new HalLinkRelation(null, relation) : new HalLinkRelation(curie, relation.substring(firstColonIndex + 1));
    }

    public static HalLinkRelation curied(String curie, String rel) {
        Assert.hasText(curie, "Curie must not be null or empty!");
        return new HalLinkRelation(curie, rel);
    }

    public static HalLinkRelation uncuried(String rel) {
        return new HalLinkRelation(null, rel);
    }

    public static HalLinkRelationBuilder curieBuilder(String curie) {
        return relation -> new HalLinkRelation(curie, relation);
    }

    public HalLinkRelation curie(String curie) {
        Assert.hasText(curie, "Curie must not be null or empty!");
        return new HalLinkRelation(curie, this.localPart);
    }

    public HalLinkRelation curieIfUncuried(String curie) {
        Assert.hasText(curie, "Curie must not be null or empty!");
        return this.isCuried() || IanaLinkRelations.isIanaRel(this.localPart) ? this : this.curie(curie);
    }

    public boolean isCuried() {
        return this.curie != null;
    }

    @Override
    public HalLinkRelation map(Function<String, String> mapper) {
        String mappedLocalPart = mapper.apply(this.localPart);
        return this.localPart.equals(mappedLocalPart) ? this : new HalLinkRelation(this.curie, mappedLocalPart);
    }

    @Override
    @JsonValue
    public String value() {
        return this.isCuried() ? String.format("%s:%s", this.curie, this.localPart) : this.localPart;
    }

    @Override
    @NonNull
    public String[] getCodes() {
        return (String[])Stream.of(this.value(), this.localPart).map((? super T it) -> String.format(RELATION_MESSAGE_TEMPLATE, it)).toArray(String[]::new);
    }

    @Override
    @NonNull
    public String getDefaultMessage() {
        return "";
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalLinkRelation)) {
            return false;
        }
        HalLinkRelation that = (HalLinkRelation)o;
        return Objects.equals(this.curie, that.curie) && Objects.equals(this.localPart, that.localPart);
    }

    public int hashCode() {
        return Objects.hash(this.curie, this.localPart);
    }

    public String toString() {
        return this.value();
    }

    public static interface HalLinkRelationBuilder {
        public HalLinkRelation relation(String var1);
    }
}

