/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationCustomizer;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationFactory;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.http.MediaType;

@Configuration(proxyBeanMethods=false)
public class HalMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final LinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final MediaTypeConfigurationFactory<HalConfiguration, ? extends MediaTypeConfigurationCustomizer<HalConfiguration>> configurationFactory;
    @Qualifier(value="messageResolver")
    private final MessageResolver resolver;
    private final AutowireCapableBeanFactory beanFactory;

    public HalMediaTypeConfiguration(LinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalConfiguration>> customizers, MessageResolver resolver, AutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.configurationFactory = new MediaTypeConfigurationFactory<HalConfiguration, MediaTypeConfigurationCustomizer<HalConfiguration>>(() -> halConfiguration.getIfAvailable(HalConfiguration::new), customizers);
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }

    @Bean
    LinkDiscoverer halLinkDisocoverer() {
        return new HalLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return this.configurationFactory.getConfiguration().getMediaTypes();
    }

    @Override
    public ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        HalConfiguration halConfiguration = this.configurationFactory.getConfiguration();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule(new Jackson2HalModule());
        mapper.setHandlerInstantiator(new Jackson2HalModule.HalHandlerInstantiator(this.relProvider, this.curieProvider.getIfAvailable(() -> CurieProvider.NONE), this.resolver, halConfiguration, this.beanFactory));
        halConfiguration.customize(mapper);
        return mapper;
    }
}

