/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.ConfigurableHandlerInstantiator;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.MessageSourceResolvableSerializer;
import org.springframework.hateoas.mediatype.hal.CollectionModelMixin;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalEmbeddedBuilder;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.LinkMixin;
import org.springframework.hateoas.mediatype.hal.RepresentationModelMixin;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

public class Jackson2HalModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;
    private static final Link CURIES_REQUIRED_DUE_TO_EMBEDS = Link.of("__rel__", "\u00af\\_(\u30c4)_/\u00af");

    public Jackson2HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
    }

    public static boolean isAlreadyRegisteredIn(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null!");
        return LinkMixin.class.equals(mapper.findMixInClassFor(Link.class));
    }

    static class HalLink {
        private final Link link;
        private final String title;

        public HalLink(Link link, @Nullable String title) {
            this.link = link;
            this.title = title;
        }

        @JsonUnwrapped
        public Link getLink() {
            return this.link;
        }

        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty
        public String getTitle() {
            return this.title;
        }
    }

    public static class EmbeddedMapper {
        private static final Function<String, String> NO_OP = Function.identity();
        private final LinkRelationProvider relProvider;
        private final CurieProvider curieProvider;
        private final boolean preferCollectionRels;
        private Function<String, String> relationTransformer = Function.identity();

        public EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels) {
            Assert.notNull((Object)relProvider, "relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
        }

        private EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels, Function<String, String> relationTransformer) {
            Assert.notNull((Object)relProvider, "relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
            this.relationTransformer = relationTransformer;
        }

        public EmbeddedMapper with(@Nullable PropertyNamingStrategy strategy) {
            Function<String, String> mapper = strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? arg_0 -> ((PropertyNamingStrategy.PropertyNamingStrategyBase)((PropertyNamingStrategy.PropertyNamingStrategyBase)strategy)).translate(arg_0) : (strategy instanceof PropertyNamingStrategies.NamingBase ? ((PropertyNamingStrategies.NamingBase)strategy)::translate : null);
            return mapper == null ? this : new EmbeddedMapper(this.relProvider, this.curieProvider, this.preferCollectionRels, mapper);
        }

        public Map<HalLinkRelation, Object> map(Iterable<?> source2) {
            Assert.notNull(source2, "Elements must not be null!");
            HalEmbeddedBuilder builder = new HalEmbeddedBuilder(this.relProvider, this.curieProvider, this.preferCollectionRels).withRelationTransformer(this.relationTransformer);
            source2.forEach(builder::add);
            return builder.asMap();
        }

        public HalLinkRelation map(LinkRelation source2) {
            Assert.notNull((Object)source2, "Link relation must not be null!");
            return HalLinkRelation.of(this.relationTransformer == NO_OP ? source2 : source2.map(this.relationTransformer));
        }

        public boolean hasCuriedEmbed(Iterable<?> source2) {
            return this.map(source2).keySet().stream().anyMatch(HalLinkRelation::isCuried);
        }
    }

    public static class TrueOnlyBooleanSerializer
    extends StdScalarSerializer<Boolean> {
        private static final long serialVersionUID = 5817795880782727569L;

        public TrueOnlyBooleanSerializer() {
            super(Boolean.class);
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Boolean value) {
            return value == null || Boolean.FALSE.equals(value);
        }

        @Override
        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBoolean(value);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("boolean", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectBooleanFormat(typeHint);
            }
        }
    }

    public static class HalHandlerInstantiator
    extends ConfigurableHandlerInstantiator {
        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver) {
            this(provider, curieProvider, resolver, new HalConfiguration(), new DefaultListableBeanFactory());
        }

        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver, HalConfiguration halConfiguration, AutowireCapableBeanFactory delegate) {
            super(delegate);
            Assert.notNull((Object)provider, "RelProvider must not be null!");
            Assert.notNull((Object)curieProvider, "CurieProvider must not be null!");
            EmbeddedMapper mapper = new EmbeddedMapper(provider, curieProvider, halConfiguration.isEnforceEmbeddedCollections());
            this.registerInstance(new HalResourcesSerializer(mapper, halConfiguration));
            this.registerInstance(new HalLinkListSerializer(curieProvider, mapper, resolver, halConfiguration));
            this.registerInstance(new MessageSourceResolvableSerializer(resolver));
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 4755806754621032622L;
        private JavaType contentType;

        public HalResourcesDeserializer() {
            this(TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Object.class), null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this(TypeFactory.defaultInstance().constructCollectionLikeType(List.class, vc), vc);
        }

        private HalResourcesDeserializer(JavaType type, @Nullable JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        @Override
        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Override
        @Nullable
        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        @Override
        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer<Object> deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException(jp, "Expected relation name");
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
            JavaType type = property.getType().getContentType();
            return new HalResourcesDeserializer(type);
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        private static final long serialVersionUID = 6420432361123210955L;

        public HalLinkListDeserializer() {
            super(TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Link.class));
        }

        @Override
        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Override
        @Nullable
        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        @Override
        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException(jp, "Expected relation name");
                }
                String relation = jp.getText();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        result.add(jp.readValueAs(Link.class).withRel(relation));
                    }
                    continue;
                }
                result.add(jp.readValueAs(Link.class).withRel(relation));
            }
            return result;
        }
    }

    public static class OptionalListJackson2Serializer
    extends ContainerSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 3700806118177419817L;
        @Nullable
        private final BeanProperty property;
        private final Map<Class<?>, JsonSerializer<Object>> serializers;
        private final HalConfiguration halConfiguration;

        public OptionalListJackson2Serializer(@Nullable BeanProperty property, HalConfiguration halConfiguration) {
            super(TypeFactory.defaultInstance().constructType((Type)((Object)List.class)));
            this.property = property;
            this.serializers = new HashMap();
            this.halConfiguration = halConfiguration;
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            Object firstElement = list.get(0);
            if (!HalLink.class.isInstance(firstElement)) {
                this.serializeContents(list, jgen, provider);
                return;
            }
            HalLink halLink = (HalLink)firstElement;
            if (list.size() == 1 && this.halConfiguration.getSingleLinkRenderModeFor(halLink.getLink().getRel()).equals((Object)HalConfiguration.RenderSingleLinks.AS_SINGLE)) {
                this.serializeContents(halLink, jgen, provider);
                return;
            }
            this.serializeContents(list, jgen, provider);
        }

        @Override
        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Override
        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Object value) {
            return false;
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new OptionalListJackson2Serializer(property, this.halConfiguration);
        }

        private void serializeContents(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            this.getOrLookupSerializerFor(value, provider).serialize(value, jgen, provider);
        }

        private JsonSerializer<Object> getOrLookupSerializerFor(Object value, SerializerProvider provider) throws JsonMappingException {
            Class<?> type = value.getClass();
            JsonSerializer<Object> serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = provider.findValueSerializer(type, this.property);
                this.serializers.put(type, serializer);
            }
            return serializer;
        }
    }

    public static class HalResourcesSerializer
    extends ContainerSerializer<Collection<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = 8030706944344625390L;
        private final EmbeddedMapper embeddedMapper;
        private final HalConfiguration configuration;
        private final BeanProperty property;

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration) {
            this(embeddedMapper, configuration, null);
        }

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration, @Nullable BeanProperty property) {
            super(TypeFactory.defaultInstance().constructType((Type)((Object)Collection.class)));
            this.embeddedMapper = embeddedMapper;
            this.configuration = configuration;
            this.property = property;
        }

        @Override
        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            EmbeddedMapper mapper = this.configuration.isApplyPropertyNamingStrategy() ? this.embeddedMapper.with(provider.getConfig().getPropertyNamingStrategy()) : this.embeddedMapper;
            Map<HalLinkRelation, Object> embeddeds = mapper.map(value);
            Object currentValue = jgen.getCurrentValue();
            if (currentValue instanceof RepresentationModel && mapper.hasCuriedEmbed(value)) {
                ((RepresentationModel)currentValue).add(CURIES_REQUIRED_DUE_TO_EMBEDS);
            }
            LinkedHashMap map = new LinkedHashMap(embeddeds.size());
            embeddeds.forEach((key, it) -> map.put(key.value(), it));
            provider.findValueSerializer(Map.class, this.property).serialize(map, jgen, provider);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalResourcesSerializer(this.embeddedMapper, this.configuration, property);
        }

        @Override
        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Override
        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Collection<?> value) {
            return value.isEmpty();
        }

        @Override
        public boolean hasSingleElement(Collection<?> value) {
            return value.size() == 1;
        }

        @Override
        @Nullable
        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializer<Links>
    implements ContextualSerializer {
        private static final long serialVersionUID = -1844788111509966406L;
        @Nullable
        private final BeanProperty property;
        private final CurieProvider curieProvider;
        private final EmbeddedMapper mapper;
        private final MessageResolver resolver;
        private final HalConfiguration halConfiguration;

        public HalLinkListSerializer(CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            this(null, curieProvider, mapper, resolver, halConfiguration);
        }

        public HalLinkListSerializer(@Nullable BeanProperty property, CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            super(TypeFactory.defaultInstance().constructType((Type)((Object)Links.class)));
            Assert.notNull((Object)curieProvider, "CurieProvider must not be null!");
            Assert.notNull((Object)mapper, "EmbeddedMapper must not be null!");
            Assert.notNull((Object)resolver, "MessageResolver must not be null!");
            Assert.notNull((Object)halConfiguration, "HalConfiguration must not be null!");
            this.property = property;
            this.curieProvider = curieProvider;
            this.mapper = mapper;
            this.resolver = resolver;
            this.halConfiguration = halConfiguration;
        }

        @Override
        public void serialize(Links value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Collection<?> curies;
            EmbeddedMapper transformingMapper;
            LinkedMultiValueMap<String, HalLink> sortedLinks = new LinkedMultiValueMap<String, HalLink>();
            ArrayList<Link> links = new ArrayList<Link>();
            boolean prefixingRequired = this.curieProvider != CurieProvider.NONE;
            boolean curiedLinkPresent = false;
            boolean skipCuries = !jgen.getOutputContext().getParent().inRoot();
            Object currentValue = jgen.getCurrentValue();
            PropertyNamingStrategy propertyNamingStrategy = provider.getConfig().getPropertyNamingStrategy();
            EmbeddedMapper embeddedMapper = transformingMapper = this.halConfiguration.isApplyPropertyNamingStrategy() ? this.mapper.with(propertyNamingStrategy) : this.mapper;
            if (currentValue instanceof CollectionModel && transformingMapper.hasCuriedEmbed((CollectionModel)currentValue)) {
                curiedLinkPresent = true;
            }
            for (Link link : value) {
                if (link.equals(CURIES_REQUIRED_DUE_TO_EMBEDS)) continue;
                LinkRelation rel = prefixingRequired ? this.curieProvider.getNamespacedRelFrom(link) : link.getRel();
                HalLinkRelation relation = transformingMapper.map(rel);
                if (relation.isCuried()) {
                    curiedLinkPresent = true;
                }
                sortedLinks.add(relation.value(), this.toHalLink(link, relation));
                links.add(link);
            }
            if (!skipCuries && prefixingRequired && curiedLinkPresent && !(curies = this.curieProvider.getCurieInformation(Links.of(links))).isEmpty()) {
                sortedLinks.addAll(HalLinkRelation.CURIES.value(), new ArrayList(curies));
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.constructType((Type)((Object)String.class));
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Object.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, valueType);
            MapSerializer serializer = MapSerializer.construct(Collections.emptySet(), (JavaType)mapType, true, null, provider.findKeySerializer(keyType, null), (JsonSerializer<Object>)new OptionalListJackson2Serializer(this.property, this.halConfiguration), null);
            serializer.serialize((Map<?, ?>)sortedLinks, jgen, provider);
        }

        private HalLink toHalLink(Link link, HalLinkRelation rel) {
            return new HalLink(link, this.resolver.resolve(rel));
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property, this.curieProvider, this.mapper, this.resolver, this.halConfiguration);
        }

        @Override
        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Override
        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Links value) {
            return value.isEmpty();
        }

        @Override
        public boolean hasSingleElement(Links value) {
            return value.toList().size() == 1;
        }

        @Override
        @Nullable
        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

