/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptions;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptionsFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HalFormsConfiguration {
    private final HalConfiguration halConfiguration;
    private final Map<Class<?>, String> patterns;
    private final Consumer<ObjectMapper> objectMapperCustomizer;
    private final HalFormsOptionsFactory options;
    private final List<MediaType> mediaTypes;

    public HalFormsConfiguration() {
        this(new HalConfiguration());
    }

    public HalFormsConfiguration(HalConfiguration halConfiguration) {
        this(halConfiguration, new HashMap(), new HalFormsOptionsFactory(), __ -> {}, Collections.singletonList(MediaTypes.HAL_FORMS_JSON));
    }

    private HalFormsConfiguration(HalConfiguration halConfiguration, Map<Class<?>, String> patterns, HalFormsOptionsFactory options, @Nullable Consumer<ObjectMapper> objectMapperCustomizer, List<MediaType> mediaTypes) {
        Assert.notNull((Object)halConfiguration, "HalConfiguration must not be null!");
        Assert.notNull(patterns, "Patterns must not be null!");
        Assert.notNull(objectMapperCustomizer, "ObjectMapper customizer must not be null!");
        Assert.notNull((Object)options, "HalFormsSuggests must not be null!");
        Assert.notNull(mediaTypes, "Media types must not be null!");
        this.halConfiguration = halConfiguration;
        this.patterns = patterns;
        this.objectMapperCustomizer = objectMapperCustomizer;
        this.options = options;
        this.mediaTypes = new ArrayList<MediaType>(mediaTypes);
    }

    public HalFormsConfiguration withPattern(Class<?> type, String pattern) {
        Assert.notNull(type, "Type must not be null!");
        Assert.hasText(pattern, "Pattern must not be null or empty!");
        HashMap newPatterns = new HashMap(this.patterns);
        newPatterns.put(type, pattern);
        return new HalFormsConfiguration(this.halConfiguration, newPatterns, this.options, this.objectMapperCustomizer, this.mediaTypes);
    }

    public HalFormsConfiguration withObjectMapperCustomizer(Consumer<ObjectMapper> objectMapperCustomizer) {
        Assert.notNull(objectMapperCustomizer, "ObjectMapper customizer must not be null!");
        return this.objectMapperCustomizer == objectMapperCustomizer ? this : new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options, objectMapperCustomizer, this.mediaTypes);
    }

    public HalFormsConfiguration withMediaType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, "MediaType must not be null!");
        if (this.mediaTypes.contains(mediaType)) {
            return this;
        }
        ArrayList<MediaType> newMediaTypes = new ArrayList<MediaType>(this.mediaTypes);
        newMediaTypes.add(this.mediaTypes.size() - 1, mediaType);
        return new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options, this.objectMapperCustomizer, newMediaTypes);
    }

    public HalFormsConfiguration customize(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null!");
        this.objectMapperCustomizer.accept(mapper);
        return this;
    }

    public <T> HalFormsConfiguration withOptions(Class<T> type, String property, Function<AffordanceModel.PropertyMetadata, HalFormsOptions> creator) {
        return new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options.withOptions(type, property, creator), this.objectMapperCustomizer, this.mediaTypes);
    }

    public HalConfiguration getHalConfiguration() {
        return this.halConfiguration;
    }

    HalFormsOptionsFactory getOptionsFactory() {
        return this.options;
    }

    Optional<String> getTypePatternFor(ResolvableType type) {
        return Optional.ofNullable(this.patterns.get(type.resolve(Object.class)));
    }

    List<MediaType> getMediaTypes() {
        return Collections.unmodifiableList(this.mediaTypes);
    }
}

