/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HalFormsHttpMessageConverter
extends TypeConstrainedMappingJackson2HttpMessageConverter {
    private final HalFormsTemplateBuilder builder;

    public HalFormsHttpMessageConverter(BeanFactory factory2, ObjectMapper mapper) {
        super(RepresentationModel.class, List.of(MediaTypes.HAL_FORMS_JSON), mapper);
        Assert.notNull((Object)factory2, "BeanFactory must not be null!");
        Assert.notNull((Object)mapper, "ObjectMapper must not be null!");
        this.builder = factory2.getBean(HalFormsTemplateBuilder.class);
    }

    @Override
    protected void writeInternal(Object object, @Nullable Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (!(object instanceof RepresentationModel)) {
            super.writeInternal(object, type, outputMessage);
            return;
        }
        RepresentationModel model = (RepresentationModel)object;
        Map<String, HalFormsTemplate> result = this.builder.findTemplates(model);
        if (result.isEmpty()) {
            HttpHeaders headers = outputMessage.getHeaders();
            headers.setContentType(MediaTypes.HAL_JSON);
        }
        super.writeInternal(object, type, outputMessage);
    }
}

