/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationCustomizer;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationFactory;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplatePropertyWriter;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.http.MediaType;

@Configuration(proxyBeanMethods=false)
class HalFormsMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final DelegatingLinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final MediaTypeConfigurationFactory<HalFormsConfiguration, ? extends MediaTypeConfigurationCustomizer<HalFormsConfiguration>> configurationFactory;
    private final MessageResolver resolver;
    private final AbstractAutowireCapableBeanFactory beanFactory;

    public HalFormsMediaTypeConfiguration(DelegatingLinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalConfiguration>> halCustomizers, ObjectProvider<HalFormsConfiguration> halFormsConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalFormsConfiguration>> halFormsCustomizers, MessageResolver resolver, AbstractAutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        Supplier<HalFormsConfiguration> defaultConfig = () -> {
            MediaTypeConfigurationFactory customizedHalConfiguration = new MediaTypeConfigurationFactory(() -> halConfiguration.getIfAvailable(HalConfiguration::new), halCustomizers);
            return new HalFormsConfiguration(customizedHalConfiguration.getConfiguration());
        };
        this.configurationFactory = new MediaTypeConfigurationFactory<HalFormsConfiguration, MediaTypeConfigurationCustomizer<HalFormsConfiguration>>(() -> (HalFormsConfiguration)halFormsConfiguration.getIfAvailable(defaultConfig), halFormsCustomizers);
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }

    @Bean
    LinkDiscoverer halFormsLinkDiscoverer() {
        return new HalFormsLinkDiscoverer();
    }

    @Bean
    HalFormsTemplateBuilder halFormsTemplateBuilder() {
        HalFormsConfiguration configuration = this.configurationFactory.getConfiguration();
        return new HalFormsTemplateBuilder(configuration, this.resolver);
    }

    @Bean
    HalFormsTemplatePropertyWriter halFormsTemplatePropertyWriter(HalFormsTemplateBuilder builder) {
        return new HalFormsTemplatePropertyWriter(builder);
    }

    @Override
    public ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        HalFormsConfiguration halFormsConfig = this.configurationFactory.getConfiguration();
        CurieProvider provider = this.curieProvider.getIfAvailable(() -> CurieProvider.NONE);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule(new Jackson2HalFormsModule());
        mapper.setHandlerInstantiator(new Jackson2HalModule.HalHandlerInstantiator(this.relProvider, provider, this.resolver, halFormsConfig.getHalConfiguration(), this.beanFactory));
        halFormsConfig.customize(mapper);
        return mapper;
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return this.configurationFactory.getConfiguration().getMediaTypes();
    }

    HalFormsConfiguration getResolvedConfiguration() {
        return this.configurationFactory.getConfiguration();
    }
}

