/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.hateoas.mediatype.MessageSourceResolvableSerializer;
import org.springframework.util.Assert;

public class HalFormsPromptedValue {
    private final Object prompt;
    private final Object value;

    private HalFormsPromptedValue(Object prompt, Object value) {
        Assert.notNull(prompt, "Prompt must not be null!");
        Assert.notNull(value, "Value must not be null!");
        this.prompt = prompt;
        this.value = value;
    }

    public static HalFormsPromptedValue of(String prompt, Object value) {
        Assert.hasText(prompt, "Prompt must not be null or empty!");
        Assert.notNull(value, "Value must not be null!");
        return new HalFormsPromptedValue(prompt, value);
    }

    public static HalFormsPromptedValue ofI18ned(String promptKey, Object value) {
        Assert.hasText(promptKey, "Prompt key must not be null or empty!");
        Assert.notNull(value, "Value must not be null!");
        return new HalFormsPromptedValue(new I18nizedPrompt(promptKey, value), value);
    }

    @JsonProperty
    public Object getPrompt() {
        return this.prompt;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    @JsonSerialize(using=MessageSourceResolvableSerializer.class)
    private static class I18nizedPrompt
    extends DefaultMessageSourceResolvable {
        private static final long serialVersionUID = 7262804826421266153L;

        I18nizedPrompt(String promptKey, Object value) {
            super(new String[]{promptKey}, new Object[]{value}, promptKey);
        }
    }
}

