/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.util.Assert;

class HalFormsTemplatePropertyWriter
extends VirtualBeanPropertyWriter {
    private static final long serialVersionUID = 6271264033606657428L;
    private final HalFormsTemplateBuilder builder;

    public HalFormsTemplatePropertyWriter(HalFormsTemplateBuilder builder) {
        Assert.notNull((Object)builder, "HalFormsTemplateBuilder must not be null!");
        this.builder = builder;
    }

    public HalFormsTemplatePropertyWriter(HalFormsTemplateBuilder builder, MapperConfig<?> config, Annotations annotations, BeanPropertyDefinition propDef, JavaType type) {
        super(propDef, annotations, type);
        this.builder = builder;
    }

    @Override
    protected Object value(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        RepresentationModel model = (RepresentationModel)bean2;
        return this.builder.findTemplates(model);
    }

    @Override
    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new HalFormsTemplatePropertyWriter(this.builder, config, declaringClass.getAnnotations(), propDef, type);
    }
}

