/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.problem;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Problem {
    private static Problem EMPTY = new Problem();
    @Nullable
    private final URI type;
    @Nullable
    private final String title;
    @Nullable
    private final HttpStatus status;
    @Nullable
    private final String detail;
    @Nullable
    private final URI instance;

    @JsonCreator
    public Problem(@JsonProperty(value="type") URI type, @JsonProperty(value="title") String title, @JsonProperty(value="status") int status, @JsonProperty(value="detail") String detail, @JsonProperty(value="instance") URI instance) {
        this(type, title, HttpStatus.resolve(status), detail, instance);
    }

    private Problem(URI type, String title, HttpStatus status, String detail, URI instance) {
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
    }

    protected Problem() {
        this(null, null, null, null, null);
    }

    public static Problem create() {
        return EMPTY;
    }

    public static <T> ExtendedProblem<T> create(T payload) {
        Assert.notNull(payload, "Payload must not be null!");
        return EMPTY.withProperties(payload);
    }

    public static Problem statusOnly(HttpStatus status) {
        Assert.notNull((Object)status, "HttpStatus must not be null!");
        return new Problem(URI.create("about:blank"), status.getReasonPhrase(), status, null, null);
    }

    public Problem withType(@Nullable URI type) {
        return this.type == type ? this : new Problem(type, this.title, this.status, this.detail, this.instance);
    }

    public Problem withTitle(@Nullable String title) {
        return this.title == title ? this : new Problem(this.type, title, this.status, this.detail, this.instance);
    }

    public Problem withStatus(@Nullable HttpStatus status) {
        return this.status == status ? this : new Problem(this.type, this.title, status, this.detail, this.instance);
    }

    public Problem withDetail(@Nullable String detail) {
        return this.detail == detail ? this : new Problem(this.type, this.title, this.status, detail, this.instance);
    }

    public Problem withInstance(@Nullable URI instance) {
        return this.instance == instance ? this : new Problem(this.type, this.title, this.status, this.detail, instance);
    }

    public <T> ExtendedProblem<T> withProperties(T payload) {
        return new ExtendedProblem<T>(this.type, this.title, this.status, this.detail, this.instance, payload);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Consumer<Map<String, Object>> consumer) {
        Assert.notNull(consumer, "Consumer must not be null!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        consumer.accept(map);
        return this.withProperties((Map<String, Object>)map);
    }

    public ExtendedProblem<Map<String, Object>> withProperties(Map<String, Object> properties) {
        Assert.notNull(properties, "Properties must not be null!");
        return new ExtendedProblem<Map<String, Object>>(this.type, this.title, this.status, this.detail, this.instance, properties);
    }

    @JsonProperty
    @Nullable
    public URI getType() {
        return this.type;
    }

    @JsonProperty
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Integer getStatusAsInteger() {
        return this.status != null ? Integer.valueOf(this.status.value()) : null;
    }

    @JsonIgnore
    @Nullable
    public HttpStatus getStatus() {
        return this.status;
    }

    @JsonProperty
    @Nullable
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty
    @Nullable
    public URI getInstance() {
        return this.instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && this.status == problem.status && Objects.equals(this.detail, problem.detail) && Objects.equals(this.instance, problem.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance);
    }

    public String toString() {
        return "Problem(type=" + String.valueOf(this.type) + ", title=" + this.title + ", status=" + String.valueOf(this.status) + ", detail=" + this.detail + ", instance=" + String.valueOf(this.instance) + ")";
    }

    public static final class ExtendedProblem<T>
    extends Problem {
        private T extendedProperties;

        ExtendedProblem(@Nullable URI type, @Nullable String title, @Nullable HttpStatus status, @Nullable String detail, @Nullable URI instance, @Nullable T properties) {
            super(type, title, status, detail, instance);
            this.extendedProperties = properties;
        }

        private ExtendedProblem() {
            super(null, null, null, null, null);
            this.extendedProperties = null;
        }

        public ExtendedProblem(T extendedProperties) {
            this.extendedProperties = extendedProperties;
        }

        @Override
        public ExtendedProblem<T> withType(@Nullable URI type) {
            return new ExtendedProblem<T>(type, this.getTitle(), this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withTitle(@Nullable String title) {
            return new ExtendedProblem<T>(this.getType(), title, this.getStatus(), this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withStatus(@Nullable HttpStatus status) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), status, this.getDetail(), this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withDetail(@Nullable String detail) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), detail, this.getInstance(), this.extendedProperties);
        }

        @Override
        public ExtendedProblem<T> withInstance(@Nullable URI instance) {
            return new ExtendedProblem<T>(this.getType(), this.getTitle(), this.getStatus(), this.getDetail(), instance, this.extendedProperties);
        }

        @JsonIgnore
        public T getProperties() {
            return this.extendedProperties;
        }

        public <S> ExtendedProblem<S> withProperties(S payload) {
            return super.withProperties(payload);
        }

        @Nullable
        @JsonUnwrapped
        T getExtendedProperties() {
            return Map.class.isInstance(this.extendedProperties) ? null : (T)this.extendedProperties;
        }

        @Nullable
        @JsonAnyGetter
        Map<String, Object> getPropertiesAsMap() {
            return Map.class.isInstance(this.extendedProperties) ? (Map)this.extendedProperties : null;
        }

        @JsonAnySetter
        void setPropertiesAsMap(String key, Object value) {
            this.getOrInitAsMap().put(key, value);
        }

        private Map<String, Object> getOrInitAsMap() {
            if (this.extendedProperties == null) {
                this.extendedProperties = new LinkedHashMap();
            }
            return (Map)this.extendedProperties;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtendedProblem)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtendedProblem that = (ExtendedProblem)o;
            return Objects.equals(this.extendedProperties, that.extendedProperties);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.extendedProperties);
        }

        @Override
        public String toString() {
            return "Problem.ExtendedProblem(extendedProperties=" + String.valueOf(this.extendedProperties) + ")";
        }
    }
}

