/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.mediatype.uber.Jackson2UberModule;
import org.springframework.hateoas.mediatype.uber.UberDocument;
import org.springframework.http.MediaType;

public class UberLinkDiscoverer
implements LinkDiscoverer {
    private final ObjectMapper mapper = new ObjectMapper();

    UberLinkDiscoverer() {
        this.mapper.registerModules(new Jackson2UberModule());
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation rel, String representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    @Override
    public Optional<Link> findLinkWithRel(LinkRelation rel, InputStream representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    @Override
    public Links findLinksWithRel(LinkRelation rel, String representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    @Override
    public Links findLinksWithRel(LinkRelation rel, InputStream representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    @Override
    public boolean supports(MediaType delimiter) {
        return delimiter.isCompatibleWith(MediaTypes.UBER_JSON);
    }

    private Links getLinks(String json) {
        try {
            return this.mapper.readValue(json, UberDocument.class).getUber().getLinks();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Links getLinks(InputStream stream) {
        try {
            return this.mapper.readValue(stream, UberDocument.class).getUber().getLinks();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

