/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import java.util.Objects;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.Plugin;
import org.springframework.util.Assert;

public interface LinkRelationProvider
extends Plugin<LookupContext> {
    public LinkRelation getItemResourceRelFor(Class<?> var1);

    public LinkRelation getCollectionResourceRelFor(Class<?> var1);

    @Override
    public boolean supports(LookupContext var1);

    public static class LookupContext {
        private final Class<?> type;
        @Nullable
        private final ResourceType resourceType;

        private LookupContext(Class<?> type, ResourceType resourceType) {
            Assert.notNull(type, "type must not be null!");
            this.type = type;
            this.resourceType = resourceType;
        }

        private static LookupContext of(Class<?> type, ResourceType resourceType) {
            return new LookupContext(type, resourceType);
        }

        public Class<?> getType() {
            return this.type;
        }

        public static LookupContext forType(Class<?> type) {
            return new LookupContext(type, null);
        }

        public static LookupContext forItemResourceRelLookup(Class<?> type) {
            return new LookupContext(type, ResourceType.ITEM);
        }

        public static LookupContext forCollectionResourceRelLookup(Class<?> type) {
            return new LookupContext(type, ResourceType.COLLECTION);
        }

        public boolean isItemRelationLookup() {
            return this.resourceType == null || ResourceType.ITEM.equals((Object)this.resourceType);
        }

        public boolean isCollectionRelationLookup() {
            return this.resourceType == null || ResourceType.COLLECTION.equals((Object)this.resourceType);
        }

        public boolean handlesType(Class<?> type) {
            return this.type.equals(type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LookupContext)) {
                return false;
            }
            LookupContext that = (LookupContext)o;
            return Objects.equals(this.type, that.type) && this.resourceType == that.resourceType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.resourceType});
        }

        public String toString() {
            ResourceType resourceType = this.resourceType;
            return String.format("LookupContext for %s for %s resource relations.", this.type.getName(), resourceType == null ? "ITEM & COLLECTION" : resourceType.name());
        }

        private static enum ResourceType {
            ITEM,
            COLLECTION;

        }
    }
}

