/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import java.util.function.Function;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.util.Assert;

public class TypedEntityLinks<T> {
    private final Function<T, ?> identifierExtractor;
    private final EntityLinks entityLinks;

    TypedEntityLinks(Function<T, ?> identifierExtractor, EntityLinks entityLinks) {
        Assert.notNull(identifierExtractor, "identifierExtractor must not be null!");
        Assert.notNull((Object)entityLinks, "entityLinks must not be null!");
        this.identifierExtractor = identifierExtractor;
        this.entityLinks = entityLinks;
    }

    public LinkBuilder linkForItemResource(T entity) {
        return this.entityLinks.linkForItemResource(entity.getClass(), this.identifierExtractor.apply(entity));
    }

    public Link linkToItemResource(T entity) {
        return this.entityLinks.linkToItemResource(entity.getClass(), this.identifierExtractor.apply(entity));
    }

    public static class ExtendedTypedEntityLinks<T>
    extends TypedEntityLinks<T> {
        private final Class<T> type;
        private final EntityLinks delegate;

        ExtendedTypedEntityLinks(Function<T, ?> identifierExtractor, EntityLinks delegate, Class<T> type) {
            super(identifierExtractor, delegate);
            Assert.notNull(type, "Type must not be null!");
            this.type = type;
            this.delegate = delegate;
        }

        public Link linkToCollectionResource() {
            return this.delegate.linkToCollectionResource(this.type);
        }
    }
}

