/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AnnotationAttribute {
    private final Class<? extends Annotation> annotationType;
    private final String attributeName;

    public AnnotationAttribute(Class<? extends Annotation> annotationType) {
        this(annotationType, null);
    }

    public AnnotationAttribute(Class<? extends Annotation> annotationType, @Nullable String attributeName) {
        Assert.notNull(annotationType, "AnnotationType must not be null!");
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Nullable
    public String getValueFrom(MethodParameter parameter) {
        Assert.notNull((Object)parameter, "MethodParameter must not be null!");
        Annotation annotation = parameter.getParameterAnnotation(this.annotationType);
        return annotation == null ? null : this.getValueFrom(annotation);
    }

    @Nullable
    public String getValueFrom(Annotation annotation) {
        Assert.notNull((Object)annotation, "Annotation must not be null!");
        return (String)(this.attributeName == null ? AnnotationUtils.getValue(annotation) : AnnotationUtils.getValue(annotation, this.attributeName));
    }
}

