/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Map;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.Relation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class AnnotationLinkRelationProvider
implements LinkRelationProvider,
Ordered {
    private final Map<Class<?>, Relation> annotationCache = new ConcurrentReferenceHashMap(128);

    @Override
    public LinkRelation getCollectionResourceRelFor(Class<?> type) {
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.collectionRelation())) {
            throw new IllegalArgumentException(String.format("No collection relation found for type %s!", type.getName()));
        }
        return LinkRelation.of(annotation.collectionRelation());
    }

    @Override
    public LinkRelation getItemResourceRelFor(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.value())) {
            throw new IllegalStateException(String.format("Type %s is not supported!", type.getName()));
        }
        return LinkRelation.of(annotation.value());
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public boolean supports(LinkRelationProvider.LookupContext context) {
        Relation relation = this.lookupAnnotation(context.getType());
        if (relation == null) {
            return false;
        }
        if (context.isItemRelationLookup()) {
            return !relation.value().equals("");
        }
        if (context.isCollectionRelationLookup()) {
            return !relation.collectionRelation().equals("");
        }
        return false;
    }

    @Nullable
    private Relation lookupAnnotation(Class<?> type) {
        return this.annotationCache.computeIfAbsent(type, key -> AnnotatedElementUtils.getMergedAnnotation(key, Relation.class));
    }
}

