/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class AnnotationMappingDiscoverer
implements MappingDiscoverer {
    private final Class<? extends Annotation> annotationType;
    private final String mappingAttributeName;

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation) {
        this(annotation, null);
    }

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation, @Nullable String mappingAttributeName) {
        Assert.notNull(annotation, "Annotation must not be null!");
        this.annotationType = annotation;
        this.mappingAttributeName = mappingAttributeName;
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        String[] mapping = this.getMappingFrom(AnnotatedElementUtils.findMergedAnnotation(type, this.annotationType));
        return mapping.length == 0 ? null : mapping[0];
    }

    @Override
    @Nullable
    public String getMapping(Method method) {
        Assert.notNull((Object)method, "Method must not be null!");
        return this.getMapping(method.getDeclaringClass(), method);
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type, Method method) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull((Object)method, "Method must not be null!");
        String[] mapping = this.getMappingFrom(AnnotatedElementUtils.findMergedAnnotation(method, this.annotationType));
        String typeMapping = this.getMapping(type);
        if (mapping.length == 0) {
            return typeMapping;
        }
        return AnnotationMappingDiscoverer.cleanup(typeMapping == null || "/".equals(typeMapping) ? mapping[0] : AnnotationMappingDiscoverer.join(typeMapping, mapping[0]));
    }

    @Override
    public Collection<HttpMethod> getRequestMethod(Class<?> type, Method method) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull((Object)method, "Method must not be null!");
        Annotation mergedAnnotation = AnnotatedElementUtils.findMergedAnnotation(method, this.annotationType);
        Object value = AnnotationUtils.getValue(mergedAnnotation, "method");
        RequestMethod[] requestMethods = (RequestMethod[])value;
        if (requestMethods == null) {
            return Collections.emptyList();
        }
        ArrayList<HttpMethod> requestMethodNames = new ArrayList<HttpMethod>();
        for (RequestMethod requestMethod : requestMethods) {
            requestMethodNames.add(HttpMethod.valueOf(requestMethod.toString()));
        }
        return requestMethodNames;
    }

    @Override
    public List<MediaType> getConsumes(Method method) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation(method, this.annotationType);
        String[] mediaTypes = (String[])AnnotationUtils.getValue(annotation, "consumes");
        return mediaTypes == null ? Collections.emptyList() : Arrays.stream(mediaTypes).map(MediaType::parseMediaType).collect(Collectors.toList());
    }

    @Override
    public String[] getParams(Method method) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation(method, this.annotationType);
        String[] params = (String[])AnnotationUtils.getValue(annotation, "params");
        return params == null ? new String[]{} : params;
    }

    private String[] getMappingFrom(@Nullable Annotation annotation) {
        Object value;
        if (annotation == null) {
            return new String[0];
        }
        Object object = value = this.mappingAttributeName == null ? AnnotationUtils.getValue(annotation) : AnnotationUtils.getValue(annotation, this.mappingAttributeName);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new IllegalStateException(String.format("Unsupported type for the mapping attribute! Support String and String[] but got %s!", value.getClass()));
    }

    private static String join(String typeMapping, String mapping) {
        return mapping.isBlank() ? typeMapping : typeMapping.concat("/").concat(mapping);
    }

    private static String cleanup(String mapping) {
        String[] parts = mapping.split("/");
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            if (!StringUtils.hasText(part)) continue;
            if (i2 != 0) {
                result.append("/");
            }
            result.append(part.contains(":") ? AnnotationMappingDiscoverer.cleanupPart(part) : part);
        }
        return (mapping.endsWith("/") ? result.append("/") : result).toString();
    }

    private static String cleanupPart(String part) {
        StringBuilder builder = new StringBuilder();
        int level = 0;
        boolean inRegex = false;
        for (int i2 = 0; i2 < part.length(); ++i2) {
            char character = part.charAt(i2);
            if (character == '{' && ++level == 1) {
                builder.append(character);
                continue;
            }
            if (level == 1 && character == ':') {
                inRegex = true;
            }
            if (character == '}' && --level == 0) {
                inRegex = false;
            }
            if (inRegex) continue;
            builder.append(character);
        }
        return builder.toString();
    }
}

