/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultMethodInvocation
implements MethodInvocation,
LastInvocationAware {
    private final Class<?> type;
    private final Method method;
    private final Object[] arguments;

    public DefaultMethodInvocation(Class<?> type, Method method, Object[] arguments) {
        Assert.notNull(type, "targetType must not be null!");
        Assert.notNull((Object)method, "method must not be null!");
        Assert.notNull((Object)arguments, "arguments must not be null!");
        this.type = type;
        this.method = method;
        this.arguments = arguments;
    }

    public DefaultMethodInvocation(Method method, Object[] arguments) {
        this(method.getDeclaringClass(), method, arguments);
    }

    @Override
    public Class<?> getTargetType() {
        return this.type;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public MethodInvocation getLastInvocation() {
        return this;
    }

    @Override
    public Iterator<Object> getObjectParameters() {
        return Collections.emptyIterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMethodInvocation)) {
            return false;
        }
        DefaultMethodInvocation that = (DefaultMethodInvocation)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.method, that.method) && Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.method);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        return "DefaultMethodInvocation(targetType=" + String.valueOf(this.type) + ", method=" + String.valueOf(this.method) + ", arguments=" + Arrays.deepToString(this.arguments) + ")";
    }
}

