/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DelegatingLinkRelationProvider
implements LinkRelationProvider {
    private final PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> providers;

    public DelegatingLinkRelationProvider(LinkRelationProvider ... providers) {
        this(PluginRegistry.of((Plugin[])providers));
    }

    public DelegatingLinkRelationProvider(PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> providers) {
        Assert.notNull(providers, "providers must not be null!");
        this.providers = providers;
    }

    @Override
    public LinkRelation getItemResourceRelFor(Class<?> type) {
        LinkRelationProvider.LookupContext context = LinkRelationProvider.LookupContext.forItemResourceRelLookup(type);
        return this.providers.getRequiredPluginFor(context).getItemResourceRelFor(type);
    }

    @Override
    public LinkRelation getCollectionResourceRelFor(Class<?> type) {
        LinkRelationProvider.LookupContext context = LinkRelationProvider.LookupContext.forCollectionResourceRelLookup(type);
        return this.providers.getRequiredPluginFor(context).getCollectionResourceRelFor(type);
    }

    @Override
    public boolean supports(LinkRelationProvider.LookupContext delimiter) {
        return this.providers.hasPluginFor(delimiter);
    }
}

