/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EmbeddedWrappers {
    private static ResolvableType SUPPLIER_OF_STREAM = ResolvableType.forClassWithGenerics(Supplier.class, Stream.class);
    private final boolean preferCollections;

    public EmbeddedWrappers(boolean preferCollections) {
        this.preferCollections = preferCollections;
    }

    public EmbeddedWrapper wrap(Object source2) {
        return this.wrap(source2, AbstractEmbeddedWrapper.NO_REL);
    }

    public EmbeddedWrapper emptyCollectionOf(Class<?> type) {
        return new EmptyCollectionEmbeddedWrapper(type);
    }

    public EmbeddedWrapper wrap(Object source2, LinkRelation rel) {
        Assert.notNull(source2, "Source must not be null!");
        Assert.notNull((Object)rel, "Link relation must not be null!");
        if (source2 instanceof EmbeddedWrapper) {
            return (EmbeddedWrapper)source2;
        }
        return source2 instanceof Collection || source2 instanceof Stream || this.preferCollections || SUPPLIER_OF_STREAM.isAssignableFrom(source2.getClass()) ? new EmbeddedCollection(EmbeddedWrappers.asCollection(source2), rel) : new EmbeddedElement(source2, rel);
    }

    private static Collection<Object> asCollection(@Nullable Object source2) {
        if (source2 == null) {
            return Collections.emptyList();
        }
        if (Collection.class.isInstance(source2)) {
            return (Collection)Collection.class.cast(source2);
        }
        if (Stream.class.isInstance(source2)) {
            return ((Stream)Stream.class.cast(source2)).collect(Collectors.toList());
        }
        if (source2.getClass().isArray()) {
            return Arrays.asList((Object[])source2);
        }
        if (SUPPLIER_OF_STREAM.isInstance(source2)) {
            return EmbeddedWrappers.asCollection(((Supplier)source2).get());
        }
        return Collections.singleton(source2);
    }

    private static abstract class AbstractEmbeddedWrapper
    implements EmbeddedWrapper {
        private static final LinkRelation NO_REL = LinkRelation.of("___norel___");
        private final LinkRelation rel;

        public AbstractEmbeddedWrapper(LinkRelation rel) {
            Assert.notNull((Object)rel, "Rel must not be null or empty!");
            this.rel = rel;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.ofNullable(this.rel).filter(it -> !it.equals(NO_REL));
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return this.rel.isSameAs(rel);
        }

        @Override
        @Nullable
        public Class<?> getRelTargetType() {
            Object peek = this.peek();
            Object object = peek = peek instanceof EntityModel ? ((EntityModel)peek).getContent() : peek;
            if (peek == null) {
                return null;
            }
            return AopUtils.getTargetClass(peek);
        }

        @Nullable
        protected abstract Object peek();
    }

    private static class EmptyCollectionEmbeddedWrapper
    implements EmbeddedWrapper {
        private final Class<?> type;

        public EmptyCollectionEmbeddedWrapper(Class<?> type) {
            Assert.notNull(type, "Element type must not be null!");
            this.type = type;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.empty();
        }

        @Override
        public Object getValue() {
            return Collections.emptySet();
        }

        @Override
        @NonNull
        public Class<?> getRelTargetType() {
            return this.type;
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return false;
        }
    }

    private static class EmbeddedCollection
    extends AbstractEmbeddedWrapper {
        private final Collection<Object> value;

        public EmbeddedCollection(Collection<Object> value, LinkRelation rel) {
            super(rel);
            Assert.notNull(value, "Collection must not be null!");
            if (AbstractEmbeddedWrapper.NO_REL.equals(rel) && value.isEmpty()) {
                throw new IllegalArgumentException("Cannot wrap an empty collection with no rel given!");
            }
            this.value = value;
        }

        @Override
        public Collection<Object> getValue() {
            return this.value;
        }

        @Override
        @Nullable
        protected Object peek() {
            return this.value.isEmpty() ? null : this.value.iterator().next();
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }
    }

    private static class EmbeddedElement
    extends AbstractEmbeddedWrapper {
        private final Object value;

        public EmbeddedElement(Object value, LinkRelation relation) {
            super(relation);
            Assert.notNull(value, "Value must not be null!");
            this.value = value;
        }

        @Override
        @NonNull
        public Object getValue() {
            return this.value;
        }

        @Override
        @NonNull
        protected Object peek() {
            return this.getValue();
        }

        @Override
        public boolean isCollectionValue() {
            return false;
        }
    }
}

