/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.util.Assert;
import org.springframework.web.util.UriUtils;

final class EncodingUtils {
    private static final Charset ENCODING = StandardCharsets.UTF_8;

    private EncodingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String encodePath(Object source2) {
        Assert.notNull(source2, "Path value must not be null!");
        try {
            return UriUtils.encodePath(source2.toString(), ENCODING);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encodeFragment(Object source2) {
        Assert.notNull(source2, "Fragment value must not be null!");
        try {
            return UriUtils.encodeFragment(source2.toString(), ENCODING);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

