/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class HeaderLinksResponseEntity<T extends RepresentationModel<?>>
extends ResponseEntity<T> {
    private HeaderLinksResponseEntity(ResponseEntity<T> entity) {
        super((RepresentationModel)entity.getBody(), (MultiValueMap<String, String>)HeaderLinksResponseEntity.getHeadersWithLinks(entity), entity.getStatusCode());
        RepresentationModel body2 = (RepresentationModel)entity.getBody();
        if (body2 != null) {
            body2.removeLinks();
        }
    }

    private HeaderLinksResponseEntity(HttpEntity<T> entity) {
        this(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(entity.getHeaders())).body((RepresentationModel)entity.getBody()));
    }

    public static <S extends RepresentationModel<?>> HeaderLinksResponseEntity<S> wrap(HttpEntity<S> entity) {
        Assert.notNull(entity, "Given HttpEntity must not be null!");
        if (entity instanceof ResponseEntity) {
            return new HeaderLinksResponseEntity((ResponseEntity)entity);
        }
        return new HeaderLinksResponseEntity<S>(entity);
    }

    public static <S extends RepresentationModel<?>> HeaderLinksResponseEntity<S> wrap(S entity) {
        Assert.notNull(entity, "ResourceSupport must not be null!");
        return new HeaderLinksResponseEntity<S>(ResponseEntity.ok(entity));
    }

    private static <T extends RepresentationModel<?>> HttpHeaders getHeadersWithLinks(ResponseEntity<T> entity) {
        RepresentationModel body2 = (RepresentationModel)entity.getBody();
        Links links = body2 != null ? body2.getLinks() : Links.NONE;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll(entity.getHeaders());
        httpHeaders.add("Link", links.toString());
        return httpHeaders;
    }
}

