/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class MethodParameters {
    private static ParameterNameDiscoverer DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final Map<Method, MethodParameters> CACHE = new ConcurrentReferenceHashMap<Method, MethodParameters>();
    private final List<MethodParameter> parameters;
    private final Map<Class<?>, List<MethodParameter>> parametersWithAnnotationCache = new ConcurrentReferenceHashMap();

    private MethodParameters(Method method) {
        this(method, null);
    }

    public static MethodParameters of(Method method) {
        Assert.notNull((Object)method, "Method must not be null!");
        return CACHE.computeIfAbsent(method, MethodParameters::new);
    }

    public MethodParameters(Method method, @Nullable AnnotationAttribute namingAnnotation) {
        Assert.notNull((Object)method, "Method must not be null!");
        this.parameters = IntStream.range(0, method.getParameterTypes().length).mapToObj(it -> new AnnotationNamingMethodParameter(method, it, namingAnnotation)).peek(it -> it.initParameterNameDiscovery(DISCOVERER)).collect(Collectors.toList());
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public Optional<MethodParameter> getParameter(String name) {
        Assert.hasText(name, "Parameter name must not be null!");
        return this.getParameters().stream().filter(it -> name.equals(it.getParameterName())).findFirst();
    }

    public List<MethodParameter> getParametersOfType(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        return this.getParameters().stream().filter(it -> it.getParameterType().equals(type)).collect(Collectors.toList());
    }

    public List<MethodParameter> getParametersWith(Class<? extends Annotation> annotation) {
        Assert.notNull(annotation, "Annotation must not be null!");
        return this.parametersWithAnnotationCache.computeIfAbsent(annotation, key -> this.getParameters().stream().filter(it -> it.hasParameterAnnotation(key)).collect(Collectors.toList()));
    }

    private static class AnnotationNamingMethodParameter
    extends SynthesizingMethodParameter {
        private final AnnotationAttribute attribute;
        private String name;
        @Nullable
        private Annotation[] combinedAnnotations;

        public AnnotationNamingMethodParameter(Method method, int parameterIndex, @Nullable AnnotationAttribute attribute) {
            super(method, parameterIndex);
            this.attribute = attribute;
        }

        @Override
        @Nullable
        public String getParameterName() {
            String foundName;
            if (this.name != null) {
                return this.name;
            }
            if (this.attribute != null && (foundName = this.attribute.getValueFrom(this)) != null) {
                this.name = foundName;
                return this.name;
            }
            return super.getParameterName();
        }

        @Override
        public Annotation[] getParameterAnnotations() {
            if (this.combinedAnnotations != null) {
                return this.combinedAnnotations;
            }
            Method method = this.getMethod();
            if (method == null) {
                throw new IllegalStateException("No method available for " + this.toString() + "!");
            }
            Annotation[] original = super.getParameterAnnotations();
            Method interfaceMethod = ClassUtils.getInterfaceMethodIfPossible(method);
            if (method.equals(interfaceMethod)) {
                return this.cacheAndReturn(original);
            }
            MethodParameter interfaceParameter = new MethodParameter(interfaceMethod, this.getParameterIndex());
            ArrayList<Annotation> originalAnnotations = new ArrayList<Annotation>(Arrays.asList(original));
            Set originalAnnotationTypes = originalAnnotations.stream().map(Object::getClass).collect(Collectors.toSet());
            Arrays.stream(interfaceParameter.getParameterAnnotations()).filter(it -> !originalAnnotationTypes.contains(it.annotationType())).forEach(originalAnnotations::add);
            return this.cacheAndReturn(originalAnnotations);
        }

        private Annotation[] cacheAndReturn(List<Annotation> annotations) {
            return this.cacheAndReturn(annotations.toArray(new Annotation[annotations.size()]));
        }

        private Annotation[] cacheAndReturn(Annotation[] annotations) {
            this.combinedAnnotations = annotations;
            return annotations;
        }
    }
}

