/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.web.util.UriTemplate;

public class UriTemplateFactory {
    private static final Map<String, UriTemplate> CACHE = new ConcurrentReferenceHashMap<String, UriTemplate>();

    public static UriTemplate templateFor(@Nullable String mapping) {
        Assert.hasText(mapping, "Mapping must not be null or empty!");
        return CACHE.computeIfAbsent(mapping, UriTemplate::new);
    }
}

