/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.core.HeaderLinksResponseEntity;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepresentationModelProcessorHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    static final ResolvableType ENTITY_MODEL_TYPE = ResolvableType.forRawClass(EntityModel.class);
    static final ResolvableType COLLECTION_MODEL_TYPE = ResolvableType.forRawClass(CollectionModel.class);
    private static final ResolvableType HTTP_ENTITY_TYPE = ResolvableType.forRawClass(HttpEntity.class);
    static final Field CONTENT_FIELD = ReflectionUtils.findField(CollectionModel.class, "content");
    private final HandlerMethodReturnValueHandler delegate;
    private final Supplier<RepresentationModelProcessorInvoker> invoker;
    private boolean rootLinksAsHeaders = false;

    public RepresentationModelProcessorHandlerMethodReturnValueHandler(HandlerMethodReturnValueHandler delegate, Supplier<RepresentationModelProcessorInvoker> invoker) {
        Assert.notNull((Object)delegate, "delegate must not be null!");
        Assert.notNull(invoker, "invoker must not be null!");
        this.delegate = delegate;
        this.invoker = invoker;
    }

    public void setRootLinksAsHeaders(boolean rootLinksAsHeaders) {
        this.rootLinksAsHeaders = rootLinksAsHeaders;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object value = returnValue;
        if (returnValue instanceof HttpEntity) {
            value = ((HttpEntity)returnValue).getBody();
        }
        if (!(value instanceof RepresentationModel)) {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
            return;
        }
        Method method = returnType.getMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("Return type %s does not expose a method!", returnType));
        }
        ResolvableType targetType = ResolvableType.forMethodReturnType(method);
        if (HTTP_ENTITY_TYPE.isAssignableFrom(targetType)) {
            targetType = targetType.getGeneric(0);
        }
        ResolvableType returnValueType = ResolvableType.forClass(value.getClass());
        if (!RepresentationModelProcessorHandlerMethodReturnValueHandler.getRawType(targetType).equals(RepresentationModelProcessorHandlerMethodReturnValueHandler.getRawType(returnValueType))) {
            targetType = returnValueType;
        }
        RepresentationModel result = this.invoker.get().invokeProcessorsFor((RepresentationModel)value, targetType);
        this.delegate.handleReturnValue(this.rewrapResult(result, returnValue), returnType, mavContainer, webRequest);
    }

    Object rewrapResult(RepresentationModel<?> newBody, @Nullable Object originalValue) {
        HttpEntity entity;
        if (!(originalValue instanceof HttpEntity)) {
            return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(newBody) : newBody;
        }
        if (originalValue instanceof ResponseEntity) {
            ResponseEntity source2 = (ResponseEntity)originalValue;
            entity = new ResponseEntity(newBody, (MultiValueMap<String, String>)source2.getHeaders(), source2.getStatusCode());
        } else {
            HttpEntity source3 = (HttpEntity)originalValue;
            entity = new HttpEntity(newBody, source3.getHeaders());
        }
        return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(entity) : entity;
    }

    private static Class<?> getRawType(ResolvableType type) {
        Class<?> rawType = type.getRawClass();
        return rawType == null ? Object.class : rawType;
    }

    static {
        if (CONTENT_FIELD != null) {
            ReflectionUtils.makeAccessible(CONTENT_FIELD);
        }
    }
}

