/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorHandlerMethodReturnValueHandler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RepresentationModelProcessorInvoker {
    private final List<ProcessorWrapper> processors;

    public RepresentationModelProcessorInvoker(Collection<RepresentationModelProcessor<?>> processors) {
        Assert.notNull(processors, "ResourceProcessors must not be null!");
        this.processors = new ArrayList<ProcessorWrapper>();
        for (RepresentationModelProcessor<?> processor : processors) {
            ResolvableType processorType = ResolvableType.forClass(RepresentationModelProcessor.class, processor.getClass());
            Class<?> rawType = processorType.getGeneric(0).resolve();
            if (rawType == null) continue;
            if (EntityModel.class.isAssignableFrom(rawType)) {
                this.processors.add(new EntityModelProcessorWrapper(processor));
                continue;
            }
            if (CollectionModel.class.isAssignableFrom(rawType)) {
                this.processors.add(new CollectionModelProcessorWrapper(processor));
                continue;
            }
            this.processors.add(new DefaultProcessorWrapper(processor));
        }
        this.processors.sort(AnnotationAwareOrderComparator.INSTANCE);
    }

    public <T extends RepresentationModel<T>> T invokeProcessorsFor(T value) {
        Assert.notNull(value, "Value must not be null!");
        return this.invokeProcessorsFor(value, ResolvableType.forClass(value.getClass()));
    }

    public <T extends RepresentationModel<T>> T invokeProcessorsFor(T value, ResolvableType referenceType) {
        Assert.notNull(value, "Value must not be null!");
        Assert.notNull((Object)referenceType, "Reference type must not be null!");
        if (RepresentationModelProcessorHandlerMethodReturnValueHandler.COLLECTION_MODEL_TYPE.isAssignableFrom(referenceType)) {
            CollectionModel collectionModel = (CollectionModel)value;
            Class<?> rawClass = referenceType.getRawClass();
            if (rawClass == null) {
                throw new IllegalArgumentException(String.format("%s does not expose a raw type!", referenceType));
            }
            ResolvableType elementTargetType = ResolvableType.forClass(CollectionModel.class, rawClass).getGeneric(0);
            ArrayList<Object> result = new ArrayList<Object>(collectionModel.getContent().size());
            for (Object element : collectionModel) {
                ResolvableType elementType = ResolvableType.forClass(element.getClass());
                if (!RepresentationModelProcessorInvoker.getRawType(elementTargetType).equals(elementType.getRawClass())) {
                    elementTargetType = elementType;
                }
                result.add(this.invokeProcessorsFor(element, elementTargetType));
            }
            if (RepresentationModelProcessorHandlerMethodReturnValueHandler.CONTENT_FIELD != null) {
                ReflectionUtils.setField(RepresentationModelProcessorHandlerMethodReturnValueHandler.CONTENT_FIELD, collectionModel, result);
            }
        }
        return (T)((RepresentationModel)this.invokeProcessorsFor((Object)value, referenceType));
    }

    private Object invokeProcessorsFor(Object value, ResolvableType type) {
        Object currentValue = value;
        for (ProcessorWrapper wrapper : this.processors) {
            if (!wrapper.supports(type, currentValue)) continue;
            currentValue = wrapper.invokeProcessor(currentValue);
        }
        return currentValue;
    }

    private static boolean isRawTypeAssignable(@Nullable ResolvableType left, @Nullable Class<?> right) {
        Assert.notNull(right, "right cannot be null!");
        return RepresentationModelProcessorInvoker.getRawType(left).isAssignableFrom(right);
    }

    private static Class<?> getRawType(@Nullable ResolvableType type) {
        return type == null ? Object.class : type.resolve(Object.class);
    }

    private static class EntityModelProcessorWrapper
    extends DefaultProcessorWrapper {
        public EntityModelProcessorWrapper(RepresentationModelProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            if (!RepresentationModelProcessorHandlerMethodReturnValueHandler.ENTITY_MODEL_TYPE.isAssignableFrom(type)) {
                return false;
            }
            return super.supports(type, value) && EntityModelProcessorWrapper.isValueTypeMatch((EntityModel)value, this.getTargetType());
        }

        private static boolean isValueTypeMatch(@Nullable EntityModel<?> entityModel, @Nullable ResolvableType target) {
            if (target == null || entityModel == null || !RepresentationModelProcessorInvoker.isRawTypeAssignable(target, entityModel.getClass())) {
                return false;
            }
            Object content = entityModel.getContent();
            if (content == null) {
                return false;
            }
            ResolvableType type = EntityModelProcessorWrapper.findGenericType(target, EntityModel.class);
            return target.isAssignableFrom(content.getClass()) || type != null && type.getGeneric(0).isAssignableFrom(ResolvableType.forClass(content.getClass()));
        }

        @Nullable
        private static ResolvableType findGenericType(@Nullable ResolvableType source2, Class<?> type) {
            if (source2 == null) {
                return null;
            }
            Class<?> rawType = RepresentationModelProcessorInvoker.getRawType(source2);
            if (Object.class.equals(rawType)) {
                return null;
            }
            if (rawType.equals(type)) {
                return source2;
            }
            return EntityModelProcessorWrapper.findGenericType(source2.getSuperType(), type);
        }
    }

    public static class CollectionModelProcessorWrapper
    extends DefaultProcessorWrapper {
        public CollectionModelProcessorWrapper(RepresentationModelProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            if (!RepresentationModelProcessorHandlerMethodReturnValueHandler.COLLECTION_MODEL_TYPE.isAssignableFrom(type)) {
                return false;
            }
            return super.supports(type, value) && this.isValueTypeMatch((CollectionModel)value, this.getTargetType());
        }

        boolean isValueTypeMatch(@Nullable CollectionModel<?> collectionModel, ResolvableType target) {
            Class collectionModelType;
            if (collectionModel == null) {
                return false;
            }
            Collection<?> content = collectionModel.getContent();
            if (content.isEmpty()) {
                return collectionModel.getResolvableType().isAssignableFrom(target);
            }
            ResolvableType superType = null;
            Iterator<Class> iterator2 = Arrays.asList(collectionModel.getClass(), CollectionModel.class).iterator();
            while (iterator2.hasNext() && (superType = CollectionModelProcessorWrapper.getSuperType(target, collectionModelType = iterator2.next())) == null) {
            }
            if (superType == null) {
                return false;
            }
            Object element = content.iterator().next();
            ResolvableType resourceType = superType.getGeneric(0);
            if (element instanceof EntityModel) {
                return EntityModelProcessorWrapper.isValueTypeMatch((EntityModel)element, resourceType);
            }
            if (element instanceof RepresentationModel) {
                return resourceType.isInstance(element);
            }
            if (element instanceof EmbeddedWrapper) {
                return RepresentationModelProcessorInvoker.isRawTypeAssignable(resourceType, ((EmbeddedWrapper)element).getRelTargetType());
            }
            return false;
        }

        @Nullable
        private static ResolvableType getSuperType(ResolvableType source2, Class<?> superType) {
            Class<?> rawType = source2.getRawClass();
            if (rawType != null && rawType.equals(superType)) {
                return source2;
            }
            ResolvableType candidate = source2.getSuperType();
            if (candidate.getRawClass() != null && superType.isAssignableFrom(candidate.getRawClass())) {
                return candidate;
            }
            for (ResolvableType interfaces : source2.getInterfaces()) {
                if (interfaces.getRawClass() == null || !superType.isAssignableFrom(interfaces.getRawClass())) continue;
                return interfaces;
            }
            return null;
        }
    }

    private static class DefaultProcessorWrapper
    implements ProcessorWrapper {
        private final RepresentationModelProcessor<?> processor;
        private final ResolvableType targetType;

        DefaultProcessorWrapper(RepresentationModelProcessor<?> processor) {
            Assert.notNull(processor, "Processor must not be null!");
            this.processor = processor;
            this.targetType = ResolvableType.forClass(RepresentationModelProcessor.class, processor.getClass()).getGeneric(0);
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            return RepresentationModelProcessorInvoker.isRawTypeAssignable(this.targetType, RepresentationModelProcessorInvoker.getRawType(type));
        }

        public Object invokeProcessor(Object object) {
            return this.processor.process((RepresentationModel)object);
        }

        @Override
        public int getOrder() {
            return CustomOrderAwareComparator.INSTANCE.getOrder(this.processor);
        }

        public ResolvableType getTargetType() {
            return this.targetType;
        }
    }

    private static interface ProcessorWrapper
    extends Ordered {
        public boolean supports(ResolvableType var1, Object var2);

        public <S> S invokeProcessor(S var1);
    }

    private static class CustomOrderAwareComparator
    extends AnnotationAwareOrderComparator {
        public static CustomOrderAwareComparator INSTANCE = new CustomOrderAwareComparator();

        private CustomOrderAwareComparator() {
        }

        @Override
        protected int getOrder(@Nullable Object obj) {
            return super.getOrder(obj);
        }
    }
}

