/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.net.URI;
import org.springframework.hateoas.server.core.UriMapping;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

class UriComponentsBuilderFactory {
    static final String REQUEST_ATTRIBUTES_MISSING = "Could not find current request via RequestContextHolder. Is this being called from a Spring MVC handler?";
    private static final String CACHE_KEY = UriComponentsBuilderFactory.class.getName() + "#BUILDER_CACHE";

    UriComponentsBuilderFactory() {
    }

    public static UriComponentsBuilder getBuilder() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return UriComponentsBuilder.fromPath("/");
        }
        URI baseUri = UriComponentsBuilderFactory.getCachedBaseUri();
        return baseUri != null ? UriComponentsBuilder.fromUri(baseUri) : UriComponentsBuilderFactory.cacheBaseUri(ServletUriComponentsBuilder.fromCurrentServletMapping());
    }

    public static UriComponentsBuilder forMapping(UriMapping mapping) {
        return UriComponentsBuilderFactory.getBuilder().path(mapping.getMapping());
    }

    public static UriComponents getComponents() {
        return UriComponentsBuilderFactory.getBuilder().build();
    }

    private static RequestAttributes getRequestAttributes() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new IllegalStateException("Could not look up RequestAttributes!");
        }
        Assert.state(requestAttributes != null, REQUEST_ATTRIBUTES_MISSING);
        Assert.isInstanceOf(ServletRequestAttributes.class, requestAttributes);
        return requestAttributes;
    }

    private static UriComponentsBuilder cacheBaseUri(UriComponentsBuilder builder) {
        URI uri = builder.build().toUri();
        UriComponentsBuilderFactory.getRequestAttributes().setAttribute(CACHE_KEY, uri, 0);
        return builder;
    }

    @Nullable
    private static URI getCachedBaseUri() {
        return (URI)UriComponentsBuilderFactory.getRequestAttributes().getAttribute(CACHE_KEY, 0);
    }
}

