/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ClassUtils;

public enum WebStack {
    WEBMVC("org.springframework.web.servlet.DispatcherServlet", "org.springframework.hateoas.config.WebMvcHateoasConfiguration", "org.springframework.web.client.RestTemplate", "org.springframework.hateoas.config.RestTemplateHateoasConfiguration"),
    WEBFLUX("org.springframework.web.reactive.DispatcherHandler", "org.springframework.hateoas.config.WebFluxHateoasConfiguration", "org.springframework.web.reactive.function.client.WebClient", "org.springframework.hateoas.config.WebClientHateoasConfiguration");

    private final boolean isServerAvailable;
    private final String serverConfiguration;
    private final boolean isClientAvailable;
    private final String clientConfiguration;

    private WebStack(String serverAvailableClazz, String serverConfigurationClazz, String clientAvailableClazz, String clientConfigurationClazz) {
        this.isServerAvailable = ClassUtils.isPresent(serverAvailableClazz, null);
        this.serverConfiguration = serverConfigurationClazz;
        this.isClientAvailable = ClassUtils.isPresent(clientAvailableClazz, null);
        this.clientConfiguration = clientConfigurationClazz;
    }

    public List<String> getAvailableConfigurations() {
        ArrayList<String> configurations = new ArrayList<String>();
        if (this.isServerAvailable) {
            configurations.add(this.serverConfiguration);
        }
        if (this.isClientAvailable) {
            configurations.add(this.clientConfiguration);
        }
        return configurations;
    }
}

