/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public record ETag(String tag, boolean weak) {
    private static final Log logger = LogFactory.getLog(ETag.class);
    private static final ETag WILDCARD = new ETag("*", false);

    public boolean isWildcard() {
        return this == WILDCARD;
    }

    public boolean compare(ETag other, boolean strong) {
        if (!StringUtils.hasLength(this.tag()) || !StringUtils.hasLength(other.tag())) {
            return false;
        }
        if (strong && (this.weak() || other.weak())) {
            return false;
        }
        return this.tag().equals(other.tag());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ETag)) return false;
        ETag oet = (ETag)other;
        if (!this.tag.equals(oet.tag)) return false;
        if (this.weak != oet.weak) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.tag.hashCode();
        result = 31 * result + Boolean.hashCode(this.weak);
        return result;
    }

    @Override
    public String toString() {
        return this.formattedTag();
    }

    public String formattedTag() {
        if (this.isWildcard()) {
            return "*";
        }
        return (this.weak ? "W/" : "") + "\"" + this.tag + "\"";
    }

    public static ETag create(String rawValue) {
        boolean weak = rawValue.startsWith("W/");
        if (weak) {
            rawValue = rawValue.substring(2);
        }
        if (rawValue.length() > 2 && rawValue.startsWith("\"") && rawValue.endsWith("\"")) {
            rawValue = rawValue.substring(1, rawValue.length() - 1);
        }
        return new ETag(rawValue, weak);
    }

    public static List<ETag> parse(String source2) {
        ArrayList<ETag> result = new ArrayList<ETag>();
        State state = State.BEFORE_QUOTES;
        int startIndex = -1;
        boolean weak = false;
        for (int i2 = 0; i2 < source2.length(); ++i2) {
            char c = source2.charAt(i2);
            if (state == State.IN_QUOTES) {
                if (c != '\"') continue;
                String tag = source2.substring(startIndex, i2);
                if (StringUtils.hasText(tag)) {
                    result.add(new ETag(tag, weak));
                }
                state = State.AFTER_QUOTES;
                startIndex = -1;
                weak = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                state = State.BEFORE_QUOTES;
                continue;
            }
            if (state == State.BEFORE_QUOTES) {
                if (c == '*') {
                    result.add(WILDCARD);
                    state = State.AFTER_QUOTES;
                    continue;
                }
                if (c == '\"') {
                    state = State.IN_QUOTES;
                    startIndex = i2 + 1;
                    continue;
                }
                if (c == 'W' && source2.length() > i2 + 2 && source2.charAt(i2 + 1) == '/' && source2.charAt(i2 + 2) == '\"') {
                    state = State.IN_QUOTES;
                    startIndex = (i2 += 2) + 1;
                    weak = true;
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Unexpected char at index " + i2);
        }
        if (state != State.IN_QUOTES && logger.isDebugEnabled()) {
            logger.debug("Expected closing '\"'");
        }
        return result;
    }

    public static String quoteETagIfNecessary(String tag) {
        if (tag.startsWith("W/\"") ? tag.length() > 3 && tag.endsWith("\"") : tag.startsWith("\"") && tag.length() > 1 && tag.endsWith("\"")) {
            return tag;
        }
        return "\"" + tag + "\"";
    }

    private static enum State {
        BEFORE_QUOTES,
        IN_QUOTES,
        AFTER_QUOTES;

    }
}

